package com.xebialabs.deployit.security;

import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.security.permission.Permission;

public interface PermissionEditor {

    Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, String rolePattern, Paging paging, Ordering order, Boolean includeInherited);

    default Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, String rolePattern, Paging paging, Ordering order) {
        return this.readPermissions(onConfigurationItem, rolePattern, paging, order, false);
    }

    default Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, Boolean includeInherited) {
        return this.readPermissions(onConfigurationItem, null, null, null, includeInherited);
    }

    default Map<Role, Set<Permission>> readPermissions(String onConfigurationItem) {
        return this.readPermissions(onConfigurationItem,  false);
    }

    void editPermissions(String onConfigurationItem, Map<Role, Set<Permission>> permissions);
}
