/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.core.Authentication;

public abstract class UserServiceTest {
    private static String ADMIN_USERNAME = "admin";
    private static String ADMIN_PASSWORD = "admin";
    private static String TEST_USERNAME = "test-user";
    private static String TEST_PASSWORD = "initial-password-for-test-user";
    private static String MODIFIED_TEST_PASSWORD = "modified-password-for-test-user";
    private UserService userService;
    private Authentication originalAuthentication;

    protected abstract UserService getUserService();

    @Before
    public void setupUserService() {
        this.userService = this.getUserService();
    }

    @Before
    public void authenticateAsAdmin() {
        this.originalAuthentication = SecurityTemplate.setCredentials((String)ADMIN_USERNAME, (String)ADMIN_PASSWORD);
    }

    @After
    public void restoreOriginalAuthentication() {
        SecurityTemplate.restoreAuthentication((Authentication)this.originalAuthentication);
    }

    @Test
    public void canReadAdminUser() {
        User adminUser = this.userService.read(ADMIN_USERNAME);
        Assert.assertThat((Object)adminUser, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)adminUser.getUsername(), (Matcher)CoreMatchers.is((Object)ADMIN_USERNAME));
        Assert.assertThat((Object)adminUser.isAdmin(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldCreateModifyAndDeleteUser() {
        this.shouldCreateUser();
        this.shouldModifyPasswordOfUser();
        this.shouldDeleteUser();
    }

    @Test
    public void shouldListUsernames() {
        this.userService.create(TEST_USERNAME + "-1", TEST_PASSWORD);
        this.userService.create(TEST_USERNAME + "-2", TEST_PASSWORD);
        List usernames = this.userService.listUsernames();
        Assert.assertThat((Object)usernames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{TEST_USERNAME + "-1", TEST_USERNAME + "-2", "admin"}));
        Assert.assertThat((Object)usernames, (Matcher)Matchers.hasSize((int)3));
        this.userService.delete(TEST_USERNAME + "-1");
        this.userService.delete(TEST_USERNAME + "-2");
    }

    @Test
    public void shouldListFilteredUsernames() {
        this.userService.create(TEST_USERNAME + "-1", TEST_PASSWORD);
        this.userService.create(TEST_USERNAME + "-2", TEST_PASSWORD);
        this.userService.create("Vanya", TEST_PASSWORD);
        this.userService.create("Paul", TEST_PASSWORD);
        List usernames = this.userService.listUsernames("user", null, null);
        Assert.assertThat((Object)usernames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"test-user-1", "test-user-2"}));
        List usernames2 = this.userService.listUsernames("user", null, new Ordering("DESC"));
        Assert.assertThat((Object)usernames2, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"test-user-2", "test-user-1"}));
        Paging paging1 = new Paging(1, 3);
        List usernames3 = this.userService.listUsernames(null, paging1, new Ordering("DESC"));
        Assert.assertThat((Object)usernames3, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"Vanya", "test-user-2", "test-user-1"}));
        Assert.assertThat((Object)usernames3, (Matcher)Matchers.hasSize((int)3));
        Paging paging2 = new Paging(4, 1);
        List usernames4 = this.userService.listUsernames(null, paging2, new Ordering("DESC"));
        Assert.assertThat((Object)usernames4, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"Paul"}));
        Assert.assertThat((Object)usernames4, (Matcher)Matchers.hasSize((int)1));
        List usernames5 = this.userService.listUsernames("test", paging1, new Ordering("userName:ASC"));
        Assert.assertThat((Object)usernames5, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)usernames5, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"test-user-1", "test-user-2"}));
        this.userService.delete(TEST_USERNAME + "-1");
        this.userService.delete(TEST_USERNAME + "-2");
        this.userService.delete("Vanya");
        this.userService.delete("Paul");
    }

    @Test
    public void shouldModifyPasswordsProvidingTheOldOne() {
        this.shouldCreateUser();
        this.shouldRejectModifyingPasswordWhenPreviousIsWrong();
        this.shouldModifyPasswordWhenProvidingPrevious();
        this.shouldDeleteUser();
    }

    @Test(expected=UserAlreadyExistsException.class)
    public void shouldRejectCreatingSameUserTwice() {
        this.userService.create("Paul", TEST_PASSWORD);
        try {
            this.userService.create("Paul", TEST_PASSWORD);
        }
        catch (UserAlreadyExistsException e) {
            this.userService.delete("Paul");
            throw e;
        }
    }

    @Test(expected=UserAlreadyExistsException.class)
    public void shouldRejectCreatingSameUserWithDifferentCaseTwice() {
        this.userService.create("Vanya", TEST_PASSWORD);
        try {
            this.userService.create("Vanya".toUpperCase(), TEST_PASSWORD);
        }
        catch (UserAlreadyExistsException e) {
            this.userService.delete("Vanya");
            throw e;
        }
    }

    private void shouldCreateUser() {
        this.assertTestUserDoesNotExist();
        this.userService.create(TEST_USERNAME, TEST_PASSWORD);
        this.assertTestUserDoesExist();
        this.assertTestUserCanLogin();
    }

    private void shouldModifyPasswordOfUser() {
        this.userService.modifyPassword(TEST_USERNAME, MODIFIED_TEST_PASSWORD);
        this.assertTestUserCanLogin();
    }

    private void shouldModifyPasswordWhenProvidingPrevious() {
        this.userService.modifyPassword(TEST_USERNAME, MODIFIED_TEST_PASSWORD, TEST_PASSWORD);
        this.assertTestUserCanLogin();
    }

    private void shouldRejectModifyingPasswordWhenPreviousIsWrong() {
        Exception caughtException = null;
        try {
            this.userService.modifyPassword(TEST_USERNAME, MODIFIED_TEST_PASSWORD, MODIFIED_TEST_PASSWORD);
        }
        catch (Exception exception) {
            caughtException = exception;
        }
        Assert.assertThat((Object)caughtException, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)caughtException, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class)));
        Assert.assertThat((Object)caughtException.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to change password: Old password does not match."));
    }

    private void shouldDeleteUser() {
        Assert.assertThat((Object)this.userService.read(TEST_USERNAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.userService.delete(TEST_USERNAME);
        this.assertTestUserDoesNotExist();
    }

    private void assertTestUserDoesNotExist() {
        try {
            this.userService.read(TEST_USERNAME);
            Assert.fail((String)("Did not expect to read user " + TEST_USERNAME));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void assertTestUserDoesExist() {
        User foundUser = this.userService.read(TEST_USERNAME);
        Assert.assertThat((Object)foundUser, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)foundUser.getUsername(), (Matcher)CoreMatchers.is((Object)TEST_USERNAME));
        Assert.assertThat((Object)foundUser.isAdmin(), (Matcher)CoreMatchers.is((Object)false));
    }

    protected abstract void assertTestUserCanLogin();
}

