package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.permission.Permission;

import java.util.*;

public class TestPermissions {

    private PermissionEditor permissionEditor;
    private RoleService roleService;
    public TestPermissions(RoleService roleService, PermissionEditor permissionEditor) {
        this.roleService = roleService;
        this.permissionEditor = permissionEditor;
    }

    public void grant(Permission p, String role, String ci) {
        Role roleForRoleName = roleService.getRoleForRoleName(role);
        grant(p, roleForRoleName, ci);
    }

    public void grant(Permission p, Role roleForRoleName, String ci) {
        Map<Role,Set<Permission>> multimap = permissionEditor.readPermissions(ci);
        multimap.computeIfAbsent(roleForRoleName, r -> new HashSet<>()).add(p);
        permissionEditor.editPermissions(ci, multimap);
    }

    public void revoke(Permission p, Role roleForRoleName, String ci) {
        Map<Role,Set<Permission>> multimap = permissionEditor.readPermissions(ci);
        multimap.computeIfAbsent(roleForRoleName, r -> new HashSet<>()).remove(p);
        permissionEditor.editPermissions(ci, multimap);
    }
}
