/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.HashSet;
import java.util.Map;

public class TestPermissions {
    private PermissionEditor permissionEditor;
    private RoleService roleService;

    public TestPermissions(RoleService roleService, PermissionEditor permissionEditor) {
        this.roleService = roleService;
        this.permissionEditor = permissionEditor;
    }

    public void grant(Permission p, String role, String ci) {
        Role roleForRoleName = this.roleService.getRoleForRoleName(role);
        this.grant(p, roleForRoleName, ci);
    }

    public void grant(Permission p, Role roleForRoleName, String ci) {
        Map multimap = this.permissionEditor.readPermissions(ci);
        multimap.computeIfAbsent(roleForRoleName, r -> new HashSet()).add(p);
        this.permissionEditor.editPermissions(ci, multimap);
    }

    public void revoke(Permission p, Role roleForRoleName, String ci) {
        Map multimap = this.permissionEditor.readPermissions(ci);
        multimap.computeIfAbsent(roleForRoleName, r -> new HashSet()).remove(p);
        this.permissionEditor.editPermissions(ci, multimap);
    }
}

