/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.XlAuthenticationProvider;
import com.xebialabs.deployit.security.authentication.XlAuthenticationToken;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;

public abstract class AuthenticationProviderTest {
    protected static final String ANONYMOUS_USERNAME = "anonymous";
    protected static final String ADMIN_USERNAME = "admin";
    protected static final String ADMIN_PASSWORD = "admin";
    protected static final String REGULAR_USERNAME = "regular-user";
    protected static final String REGULAR_PASSWORD = "the-password-of-the-regular-user";
    private AuthenticationProvider provider;

    protected abstract UserService getUserService();

    @Before
    public void setupAuthenticationProvider() throws IllegalAccessException {
        this.provider = new XlAuthenticationProvider(this.getUserService());
    }

    @Test(expected=BadCredentialsException.class)
    public void anonymousUserShouldNotAuthenticateWithAnyPassword() {
        String anonymousPassword = "1234";
        XlAuthenticationToken token = new XlAuthenticationToken((Object)ANONYMOUS_USERNAME, (Object)"1234");
        this.provider.authenticate((Authentication)token);
    }

    @Test
    public void adminUserShouldAuthenticateWithCorrectPassword() {
        XlAuthenticationToken token = new XlAuthenticationToken((Object)"admin", (Object)"admin");
        Authentication authenticated = this.provider.authenticate((Authentication)token);
        Assert.assertThat((Object)authenticated.getPrincipal().toString(), (Matcher)CoreMatchers.is((Object)"admin"));
        Assert.assertThat((Object)authenticated.getCredentials().toString(), (Matcher)CoreMatchers.is((Object)"admin"));
    }

    @Test(expected=BadCredentialsException.class)
    public void adminUserShouldNotAuthenticateWithIncorrectPassword() {
        XlAuthenticationToken token = new XlAuthenticationToken((Object)"admin", (Object)"admin-incorrect");
        this.provider.authenticate((Authentication)token);
    }

    @Test
    public void regularUserShouldAuthenticateWithCorrectPassword() {
        XlAuthenticationToken token = new XlAuthenticationToken((Object)REGULAR_USERNAME, (Object)REGULAR_PASSWORD);
        Authentication authenticated = this.provider.authenticate((Authentication)token);
        Assert.assertThat((Object)authenticated.getPrincipal().toString(), (Matcher)CoreMatchers.is((Object)REGULAR_USERNAME));
        Assert.assertThat((Object)authenticated.getCredentials().toString(), (Matcher)CoreMatchers.is((Object)REGULAR_PASSWORD));
    }

    @Test(expected=BadCredentialsException.class)
    public void regularUserShouldNotAuthenticateWithIncorrectPassword() {
        XlAuthenticationToken token = new XlAuthenticationToken((Object)REGULAR_USERNAME, (Object)"the-password-of-the-regular-user-incorrect");
        this.provider.authenticate((Authentication)token);
    }

    @Test(expected=BadCredentialsException.class)
    public void shouldNotAuthenticateWithWrongUsername() {
        XlAuthenticationToken token = new XlAuthenticationToken((Object)"regular-user-incorrect", (Object)REGULAR_PASSWORD);
        this.provider.authenticate((Authentication)token);
    }
}

