/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class RoleServiceTest {
    private RoleService roleService;
    private List<Role> roleAssignments;
    private Role developer;
    private Role deployer;
    private Role administrator;

    protected abstract RoleService getRoleService();

    @Before
    public void init() {
        this.roleService = this.getRoleService();
        this.developer = new Role("developer");
        this.deployer = new Role("deployer");
        this.administrator = new Role("administrator");
        this.developer.getPrincipals().add("john");
        this.deployer.getPrincipals().addAll(Arrays.asList("john", "sam"));
        this.administrator.getPrincipals().add("kate");
        this.roleAssignments = Arrays.asList(this.developer, this.deployer, this.administrator);
    }

    @After
    public void clear() {
        this.roleService.writeRoleAssignments(new ArrayList());
    }

    @Test
    public void shouldNotFailOnNoRolesRead() {
        List rolePrincipalsMap = this.roleService.readRoleAssignments();
        Assert.assertThat((Object)rolePrincipalsMap, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)rolePrincipalsMap, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void shouldReadWrittenRoles() {
        List roles = this.roleService.getRoles();
        Assert.assertThat((Object)roles, (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.roleService.writeRoleAssignments(this.roleAssignments);
        roles = this.roleService.getRoles();
        Assert.assertThat((Object)roles, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    public void shouldReadAndWriteRoleAssignments() {
        this.roleService.writeRoleAssignments(this.roleAssignments);
        List result = this.roleService.readRoleAssignments();
        Assert.assertThat(new HashSet(result), (Matcher)CoreMatchers.equalTo(new HashSet<Role>(this.roleAssignments)));
    }

    @Test
    public void shouldOverwriteExistingRolesWithNew() {
        this.roleService.writeRoleAssignments(this.roleAssignments);
        this.roleService.writeRoleAssignments(new ArrayList());
        Assert.assertThat((Object)this.roleService.readRoleAssignments(), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void shouldGetNoRolesForNonExistingPrincipal() {
        List rolesFor = this.roleService.getRolesFor("non-existing");
        Assert.assertThat((Object)rolesFor, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void shouldGetRolesForExistingPrincipals() {
        this.roleService.writeRoleAssignments(this.roleAssignments);
        List rolesForJohn = this.roleService.getRolesFor("john");
        Assert.assertThat((Object)rolesForJohn, (Matcher)Matchers.hasItem((Object)this.developer));
        Assert.assertThat((Object)rolesForJohn, (Matcher)Matchers.hasItem((Object)this.deployer));
        List rolesForKate = this.roleService.getRolesFor("kate");
        Assert.assertThat((Object)rolesForKate, (Matcher)Matchers.hasItem((Object)this.administrator));
    }

    @Test
    public void shouldAssignNewIdToNewRole() {
        this.roleService.writeRoleAssignments(this.roleAssignments);
        ArrayList<Role> otherRoleAssignments = new ArrayList<Role>();
        otherRoleAssignments.addAll(this.roleAssignments);
        Role loser = new Role("loser");
        loser.getPrincipals().add("mallory");
        otherRoleAssignments.add(loser);
        otherRoleAssignments.remove(this.developer);
        this.roleService.writeRoleAssignments(otherRoleAssignments);
        List roles = this.roleService.getRoles();
        Assert.assertThat((Object)roles, (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Object)this.developer)));
        Assert.assertThat((Object)roles, (Matcher)Matchers.hasItem((Object)loser));
        Assert.assertThat((Object)((Role)roles.get(roles.indexOf(loser))).getId(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void shouldAssignNewIdToNewRoleWithMinus1Id() {
        this.roleService.writeRoleAssignments(this.roleAssignments);
        ArrayList<Role> otherRoleAssignments = new ArrayList<Role>();
        otherRoleAssignments.addAll(this.roleAssignments);
        Role loser = new Role(null, "loser");
        loser.getPrincipals().add("mallory");
        otherRoleAssignments.add(loser);
        otherRoleAssignments.remove(this.developer);
        this.roleService.writeRoleAssignments(otherRoleAssignments);
        List roles = this.roleService.getRoles();
        Assert.assertThat((Object)roles, (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Object)this.developer)));
        Assert.assertThat((Object)roles, (Matcher)Matchers.hasItem((Object)loser));
        Assert.assertThat((Object)((Role)roles.get(roles.indexOf(loser))).getId(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void shouldNotMergeTwoRolesWithEmptyRoleId() {
        this.roleService.writeRoleAssignments(this.roleAssignments);
        ArrayList<Role> otherRoleAssignments = new ArrayList<Role>();
        otherRoleAssignments.addAll(this.roleAssignments);
        Role loser = new Role("loser");
        loser.getPrincipals().add("mallory");
        Role superman = new Role("superman");
        superman.getPrincipals().add("clark");
        otherRoleAssignments.add(loser);
        otherRoleAssignments.add(superman);
        this.roleService.writeRoleAssignments(otherRoleAssignments);
        List roles = this.roleService.readRoleAssignments();
        Assert.assertThat((Object)roles, (Matcher)Matchers.hasItem((Object)loser));
        Assert.assertThat((Object)roles, (Matcher)Matchers.hasItem((Object)superman));
        Assert.assertThat((Object)((Role)roles.get(roles.indexOf(loser))).getPrincipals(), (Matcher)Matchers.hasItem((Object)"mallory"));
        Assert.assertThat((Object)((Role)roles.get(roles.indexOf(loser))).getPrincipals(), (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Object)"clark")));
        Assert.assertThat((Object)((Role)roles.get(roles.indexOf(superman))).getPrincipals(), (Matcher)Matchers.hasItem((Object)"clark"));
        Assert.assertThat((Object)((Role)roles.get(roles.indexOf(superman))).getPrincipals(), (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Object)"mallory")));
    }
}

