/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.Team;
import com.xebialabs.deployit.security.TeamService;
import com.xebialabs.deployit.security.TestPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.permission.PlatformTestPermissions;
import com.xebialabs.xlplatform.test.ci.CiHelper;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class PermissionEnforcerTest {
    private PermissionHandler loginHandler;
    private PermissionHandler readHandler;
    private Directory envGroup;
    private Directory envDept;
    private Environment environment;
    private PermissionEnforcer permissionEnforcer;
    private Directory appGroup;
    private RoleService roleService;
    private TeamService teamService;
    private Role devver;
    private Role admin;
    private Team teamA;
    private Team teamB;
    private RepositoryService repositoryService;
    private TestPermissions permissions;

    protected abstract RoleService getRoleService();

    protected abstract TeamService getTeamService();

    protected abstract PermissionChecker getPermissionChecker();

    protected abstract PermissionEditor getPermissionEditor();

    protected abstract RepositoryService getRepositoryService();

    @Before
    public void setup() {
        this.roleService = this.getRoleService();
        this.teamService = this.getTeamService();
        PermissionEditor pe = this.getPermissionEditor();
        this.permissions = new TestPermissions(this.roleService, pe);
        this.permissionEnforcer = new PermissionEnforcer(this.getPermissionChecker(), this.roleService);
        new SecurityServiceLocator(this.permissionEnforcer);
        this.loginHandler = PlatformPermissions.LOGIN.getPermissionHandler();
        this.readHandler = PlatformPermissions.READ.getPermissionHandler();
        this.repositoryService = this.getRepositoryService();
        CiHelper ciHelper = new CiHelper(this.repositoryService);
        this.envDept = ciHelper.createDirectory("Environments/dept");
        this.envGroup = ciHelper.createDirectory("Environments/dept/group");
        this.appGroup = ciHelper.createDirectory("Applications/group");
        this.environment = (Environment)ciHelper.createConfigurationItem(Environment.class, this.envGroup.getId() + "/env1");
        this.devver = new Role("devver");
        this.admin = new Role("administrator");
        this.teamA = new Team("A-Team").withRoles(new String[]{this.devver.getName()});
        this.teamB = new Team("B-Team").withPrincipals(new String[]{"user-1"});
        this.devver.getPrincipals().add("group-1");
        this.admin.getPrincipals().add("admin-group");
        this.roleService.writeRoleAssignments((List)Lists.newArrayList((Object[])new Role[]{this.devver, this.admin}));
        this.teamService.writeTeams((List)Lists.newArrayList((Object[])new Team[]{this.teamA}), this.envGroup.getId());
        this.teamService.writeTeams((List)Lists.newArrayList((Object[])new Team[]{this.teamA, this.teamB}), this.envDept.getId());
        SecurityTemplate.setAuthentication((Authentication)new TestingAuthenticationToken((Object)"admin", (Object)"admin", new String[]{"ROLE_ADMIN"}));
        this.permissions.grant(PlatformPermissions.EDIT_SECURITY, this.devver, null);
        SecurityTemplate.setAuthentication((Authentication)new TestingAuthenticationToken((Object)"user-1", (Object)"user-1", new String[]{"group-1"}));
    }

    @After
    public void cleanup() {
        this.repositoryService.delete(new String[]{this.envGroup.getId()});
        this.repositoryService.delete(new String[]{this.envDept.getId()});
        this.repositoryService.delete(new String[]{this.appGroup.getId()});
        this.roleService.writeRoleAssignments((List)Lists.newArrayList());
    }

    @Test
    public void shouldCheckForPermissionGrantedToRole() {
        MatcherAssert.assertThat((Object)this.loginHandler.hasPermission(null), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.LOGIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.loginHandler.hasPermission(null), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.LOGIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.loginHandler.hasPermission(null), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldCheckForCiGroupPermissionGrantedToRole() {
        this.checkPermissions(this.devver, this.environment.getId(), this.envGroup.getId());
    }

    @Test
    public void shouldCheckForCiPermissionGrantedToTeamOnSameNode() {
        this.checkPermissions((Role)this.teamA, this.envGroup.getId(), this.envGroup.getId());
    }

    @Test
    public void shouldCheckForCiPermissionGrantedToTeamOnParentNode() {
        this.checkPermissions((Role)this.teamA, this.environment.getId(), this.envGroup.getId());
    }

    private void checkPermissions(Role role, String onConfiguration, String ci) {
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(onConfiguration), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.READ, role, ci);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(onConfiguration), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.READ, role, ci);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(onConfiguration), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldHaveReadPermissionWhenGrantedCiLevelPermission() {
        this.checkRelatedReadPermission(PlatformPermissions.READ, this.envGroup.getId(), this.envGroup.getId());
        this.checkRelatedReadPermission(PlatformTestPermissions.IMPLICIT_READ_APP, this.appGroup.getId(), this.appGroup.getId());
    }

    private void checkRelatedReadPermission(Permission p, String grantedNode, String checkNode) {
        this.permissions.grant(p, this.devver, grantedNode);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)p.getPermissionHandler().hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(p, this.devver, grantedNode);
        MatcherAssert.assertThat((Object)p.getPermissionHandler().hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotRevokedExplicitReadWhenRevokingAnotherPermission() {
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        PermissionHandler deployHandler = PlatformTestPermissions.IMPLICIT_READ.getPermissionHandler();
        this.permissions.grant(PlatformTestPermissions.IMPLICIT_READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)deployHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformTestPermissions.IMPLICIT_READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)deployHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.READ, this.devver, this.envGroup.getId());
    }

    @Test
    public void shouldNotRevokedExplicitReadWhenRevokingAnotherPermissionFromOtherTeam() {
        PermissionHandler editRepoHandler = PlatformPermissions.EDIT_REPO.getPermissionHandler();
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.READ, (Role)this.teamA, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.EDIT_REPO, (Role)this.teamB, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.EDIT_REPO, (Role)this.teamB, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.revoke(PlatformPermissions.READ, (Role)this.teamA, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotRemoveReadPermissionForUserWhenAnotherUserHasGrantedRelatedPermission() {
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        this.permissions.grant(PlatformTestPermissions.IMPLICIT_READ, this.admin, this.envGroup.getId());
        this.permissions.revoke(PlatformTestPermissions.IMPLICIT_READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformTestPermissions.IMPLICIT_READ, this.admin, this.envGroup.getId());
        this.permissions.revoke(PlatformPermissions.READ, this.devver, this.envGroup.getId());
    }

    @Test
    public void shouldBeAdminUserWhenGrantedAdminPermission() {
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.ADMIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.permissionEnforcer.isAdmin((Collection)Lists.newArrayList((Object[])new String[]{"user-1"}), (List)Lists.newArrayList((Object[])new Role[]{this.devver})), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.ADMIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldBeAdminUserWhenGrantedCorrectAuthority() {
        SecurityTemplate.setAuthentication((Authentication)new TestingAuthenticationToken((Object)"user-1", (Object)"user-1", new String[]{"ROLE_ADMIN"}));
        MatcherAssert.assertThat((Object)this.permissionEnforcer.isAdmin((Collection)Lists.newArrayList((Object[])new String[]{"user-1", "ROLE_ADMIN"}), (List)Lists.newArrayList()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRevokePermissionInOneGoWhenGrantedTwice() {
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRevokePermissionWhenRemovingUserFromTeamMembership() {
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.READ, (Role)this.teamB, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.teamB.withPrincipals(new String[]{"unknown"});
        this.teamService.writeTeams((List)Lists.newArrayList((Object[])new Team[]{this.teamB}), this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.teamB.withPrincipals(new String[]{"user-1"});
        this.teamService.writeTeams((List)Lists.newArrayList((Object[])new Team[]{this.teamB}), this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
    }
}

