/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.TestPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.permission.PlatformTestPermissions;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class PermissionEnforcerTest {
    private PermissionHandler loginHandler;
    private PermissionHandler readHandler;
    private PermissionEnforcer permissionEnforcer;
    private RoleService roleService;
    protected Directory envGroup;
    protected Directory envDept;
    protected Environment environment;
    protected Directory appGroup;
    private Role devver;
    private Role admin;
    private Role lRoleA;
    private Role lRoleB;
    private TestPermissions permissions;

    protected abstract RoleService getRoleService();

    protected abstract PermissionChecker getPermissionChecker();

    protected abstract PermissionEditor getPermissionEditor();

    @Before
    public void setup() {
        this.roleService = this.getRoleService();
        PermissionEditor pe = this.getPermissionEditor();
        this.permissions = new TestPermissions(this.roleService, pe);
        this.permissionEnforcer = new PermissionEnforcer(this.getPermissionChecker(), this.roleService);
        new SecurityServiceLocator(this.permissionEnforcer, null);
        this.loginHandler = PlatformPermissions.LOGIN.getPermissionHandler();
        this.readHandler = PlatformPermissions.READ.getPermissionHandler();
        this.devver = new Role("devver");
        this.admin = new Role("administrator");
        this.lRoleA = new Role("A-Role").withRoles(new String[]{this.devver.getName()});
        this.lRoleB = new Role("B-Role").withPrincipals(new String[]{"user-1"});
        this.devver.getPrincipals().add("group-1");
        this.admin.getPrincipals().add("admin-group");
        this.roleService.writeRoleAssignments((List)Lists.newArrayList((Object[])new Role[]{this.devver, this.admin}));
        this.roleService.writeRoleAssignments(this.envGroup.getId(), (List)Lists.newArrayList((Object[])new Role[]{this.lRoleA}));
        this.roleService.writeRoleAssignments(this.envDept.getId(), (List)Lists.newArrayList((Object[])new Role[]{this.lRoleA, this.lRoleB}));
        SecurityTemplate.setAuthentication((Authentication)new TestingAuthenticationToken((Object)"admin", (Object)"admin", new String[]{"ROLE_ADMIN"}));
        this.permissions.grant(PlatformPermissions.EDIT_SECURITY, this.devver, null);
        SecurityTemplate.setAuthentication((Authentication)new TestingAuthenticationToken((Object)"user-1", (Object)"user-1", new String[]{"group-1"}));
    }

    @After
    public void cleanup() {
        this.roleService.writeRoleAssignments((List)Lists.newArrayList());
    }

    @Test
    public void shouldCheckForPermissionGrantedToRole() {
        MatcherAssert.assertThat((Object)this.loginHandler.hasPermission((String)null), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.LOGIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.loginHandler.hasPermission((String)null), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.LOGIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.loginHandler.hasPermission((String)null), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldCheckForCiGroupPermissionGrantedToRole() {
        this.checkPermissions(this.devver, this.environment.getId(), this.envGroup.getId());
    }

    @Test
    public void shouldCheckForCiPermissionGrantedToRoleOnSameNode() {
        this.checkPermissions(this.lRoleA, this.envGroup.getId(), this.envGroup.getId());
    }

    @Test
    public void shouldCheckForCiPermissionGrantedToRoleOnParentNode() {
        this.checkPermissions(this.lRoleA, this.environment.getId(), this.envGroup.getId());
    }

    private void checkPermissions(Role role, String onConfiguration, String ci) {
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(onConfiguration), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.READ, role, ci);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(onConfiguration), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.READ, role, ci);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(onConfiguration), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldHaveReadPermissionWhenGrantedCiLevelPermission() {
        this.checkRelatedReadPermission(PlatformPermissions.READ, this.envGroup.getId(), this.envGroup.getId());
        this.checkRelatedReadPermission(PlatformTestPermissions.IMPLICIT_READ_APP, this.appGroup.getId(), this.appGroup.getId());
    }

    private void checkRelatedReadPermission(Permission p, String grantedNode, String checkNode) {
        this.permissions.grant(p, this.devver, grantedNode);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)p.getPermissionHandler().hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(p, this.devver, grantedNode);
        MatcherAssert.assertThat((Object)p.getPermissionHandler().hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(checkNode), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotRevokedExplicitReadWhenRevokingAnotherPermission() {
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        PermissionHandler deployHandler = PlatformTestPermissions.IMPLICIT_READ.getPermissionHandler();
        this.permissions.grant(PlatformTestPermissions.IMPLICIT_READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)deployHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformTestPermissions.IMPLICIT_READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)deployHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.READ, this.devver, this.envGroup.getId());
    }

    @Test
    public void shouldNotRevokedExplicitReadWhenRevokingAnotherPermissionFromOtherRole() {
        PermissionHandler editRepoHandler = PlatformPermissions.EDIT_REPO.getPermissionHandler();
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.READ, this.lRoleA, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.EDIT_REPO, this.lRoleB, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.EDIT_REPO, this.lRoleB, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.revoke(PlatformPermissions.READ, this.lRoleA, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)editRepoHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotRemoveReadPermissionForUserWhenAnotherUserHasGrantedRelatedPermission() {
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        this.permissions.grant(PlatformTestPermissions.IMPLICIT_READ, this.admin, this.envGroup.getId());
        this.permissions.revoke(PlatformTestPermissions.IMPLICIT_READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformTestPermissions.IMPLICIT_READ, this.admin, this.envGroup.getId());
        this.permissions.revoke(PlatformPermissions.READ, this.devver, this.envGroup.getId());
    }

    @Test
    public void shouldBeAdminUserWhenGrantedAdminPermission() {
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.ADMIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.permissionEnforcer.isAdmin((Collection)Lists.newArrayList((Object[])new String[]{"user-1"}), (List)Lists.newArrayList((Object[])new Role[]{this.devver})), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.ADMIN, this.devver, null);
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldBeAdminUserWhenGrantedCorrectAuthority() {
        SecurityTemplate.setAuthentication((Authentication)new TestingAuthenticationToken((Object)"user-1", (Object)"user-1", new String[]{"ROLE_ADMIN"}));
        MatcherAssert.assertThat((Object)this.permissionEnforcer.isAdmin((Collection)Lists.newArrayList((Object[])new String[]{"user-1", "ROLE_ADMIN"}), (List)Lists.newArrayList()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRevokePermissionInOneGoWhenGrantedTwice() {
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        this.permissions.grant(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.permissions.revoke(PlatformPermissions.READ, this.devver, this.envGroup.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.envGroup.getId()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRevokePermissionWhenRemovingUserFromLocalRoleMembership() {
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.permissions.grant(PlatformPermissions.READ, this.lRoleB, this.envDept.getId());
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
        this.lRoleB.withPrincipals(new String[]{"unknown"});
        this.roleService.writeRoleAssignments(this.envDept.getId(), (List)Lists.newArrayList((Object[])new Role[]{this.lRoleB}));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)false));
        this.lRoleB.withPrincipals(new String[]{"user-1"});
        this.roleService.writeRoleAssignments(this.envDept.getId(), (List)Lists.newArrayList((Object[])new Role[]{this.lRoleB}));
        MatcherAssert.assertThat((Object)this.readHandler.hasPermission(this.environment.getId()), (Matcher)Matchers.equalTo((Object)true));
    }
}

