package com.xebialabs.xlplatform.security.sql.db

import java.util.UUID

import com.xebialabs.deployit.booter.local.utils.Strings.isEmpty

object Ids {
  val GLOBAL_SECURITY_ALIAS = "global"

  val GLOBAL_SCOPE_CI_ID: Int = -1

  def generate(): String = UUID.randomUUID().toString

  def isGlobalId(id: Option[String]): Boolean = id match {
    case Some(ciId) if ciId != GLOBAL_SECURITY_ALIAS && !isEmpty(ciId) => false
    case _ => true
  }

  def toDbId(id: Option[String]): Int =
    id.collect {
      case ciId if ciId != GLOBAL_SECURITY_ALIAS && !isEmpty(ciId) => ciId.toInt
    }.getOrElse(GLOBAL_SCOPE_CI_ID)

  def fromDbId(id: Int): String = if (id == GLOBAL_SCOPE_CI_ID) GLOBAL_SECURITY_ALIAS else id.toString

}
