package com.xebialabs.xlplatform.security.sql

import java.util

import com.xebialabs.deployit.security.{PermissionLister, Role}
import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlplatform.security.sql.db.Ids.fromDbId
import com.xebialabs.xlplatform.security.sql.db.Tables
import slick.jdbc.JdbcProfile

import scala.collection.JavaConverters._

class SqlPermissionLister(securityDatabase: Database) extends PermissionLister {

  import securityDatabase._

  val profile: JdbcProfile = config.databaseType.profile

  import profile.api._

  override def listPermissions(role: Role): util.Map[String, util.List[String]] = listPermissions(Seq(role))

  override def listPermissions(roles: util.List[Role]): util.Map[String, util.List[String]] = listPermissions(roles.asScala)

  override def listGlobalPermissions(roles: util.List[Role]): util.Map[String, util.List[String]] = listPermissions(roles.asScala, includeCiPermissions = false)

  private def listPermissions(roles: Seq[Role], includeCiPermissions: Boolean = true): util.Map[String, util.List[String]] = {
    var query = Tables.roles
      .join(Tables.rolePermissions).on(_.id === _.roleId)
      .filter(_._1.id.in(roles.map(_.getId)))
      .map(_._2)

    if (!includeCiPermissions) {
      query = query.filter(_.isGlobal)
    }

    runAwait(query.result)
      .map(permission => fromDbId(permission.ciId) -> permission.permissionName)
      .groupBy(_._1)
      .mapValues(_.toList.map(_._2).asJavaMutable())
      .asJavaMutable()
  }

}
