/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.security;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.ScalaJcrTemplate;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.security.JcrPermissions;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.Team;
import com.xebialabs.deployit.security.TeamService;
import com.xebialabs.xlplatform.security.JcrTeamService$;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tuq!B\u0001\u0003\u0011\u0003Y\u0011A\u0004&deR+\u0017-\\*feZL7-\u001a\u0006\u0003\u0007\u0011\t\u0001b]3dkJLG/\u001f\u0006\u0003\u000b\u0019\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\bKGJ$V-Y7TKJ4\u0018nY3\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9!$\u0004b\u0001\n\u0003Y\u0012!\u0004(B\u001b\u0016{\u0006KU(Q\u000bJ#\u0016,F\u0001\u001d!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003mC:<'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011aa\u0015;sS:<\u0007BB\u0013\u000eA\u0003%A$\u0001\bO\u00036+u\f\u0015*P!\u0016\u0013F+\u0017\u0011\t\u000f\u001dj!\u0019!C\u00017\u0005q!k\u0014'F'~\u0003&k\u0014)F%RK\u0006BB\u0015\u000eA\u0003%A$A\bS\u001f2+5k\u0018)S\u001fB+%\u000bV-!\u0011\u001dYSB1A\u0005\u0002m\t1\u0003\u0015*J\u001d\u000eK\u0005+\u0011'T?B\u0013v\nU#S)fCa!L\u0007!\u0002\u0013a\u0012\u0001\u0006)S\u0013:\u001b\u0015\nU!M'~\u0003&k\u0014)F%RK\u0006\u0005C\u00040\u001b\t\u0007I\u0011A\u000e\u0002!Q+\u0015)T0O\u001f\u0012+u\f\u0015*F\r&C\u0006BB\u0019\u000eA\u0003%A$A\tU\u000b\u0006kuLT(E\u000b~\u0003&+\u0012$J1\u0002BqaM\u0007C\u0002\u0013\u00051$\u0001\rU\u000b\u0006kuLT(E\u000b~\u001bV)\u0011*D\u0011~\u0003\u0016\t\u0016+F%:Ca!N\u0007!\u0002\u0013a\u0012!\u0007+F\u00036{fj\u0014#F?N+\u0015IU\"I?B\u000bE\u000bV#S\u001d\u00022AA\u0004\u0002\u0001oM\u0019a\u0007O\u001e\u0011\u0005uI\u0014B\u0001\u001e\u001f\u0005\u0019y%M[3diB\u0011A\bQ\u0007\u0002{)\u00111A\u0010\u0006\u0003\u007f\u0019\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0003v\u00121\u0002V3b[N+'O^5dK\"A1I\u000eB\u0001B\u0003%A)A\u0006kGJ$V-\u001c9mCR,\u0007CA#I\u001b\u00051%BA$?\u0003\rQ7M]\u0005\u0003\u0013\u001a\u0013\u0001cU2bY\u0006T5M\u001d+f[Bd\u0017\r^3\t\u0011-3$\u0011!Q\u0001\n1\u000b1B]8mKN+'O^5dKB\u0011A(T\u0005\u0003\u001dv\u00121BU8mKN+'O^5dK\")qC\u000eC\u0001!R\u0019\u0011KU*\u0011\u000511\u0004\"B\"P\u0001\u0004!\u0005\"B&P\u0001\u0004a\u0005bB+7\u0005\u0004%IAV\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\u000bMdg\r\u000e6\u000b\u0003q\u000b1a\u001c:h\u0013\tq\u0016L\u0001\u0004M_\u001e<WM\u001d\u0005\u0007AZ\u0002\u000b\u0011B,\u0002\u000f1|wmZ3sA!)!M\u000eC\u0001G\u0006Yq-\u001a;UK\u0006l7OR8s)\r!W.\u001e\t\u0004K\"TW\"\u00014\u000b\u0005\u001d\u0004\u0013\u0001B;uS2L!!\u001b4\u0003\t1K7\u000f\u001e\t\u0003y-L!\u0001\\\u001f\u0003\tQ+\u0017-\u001c\u0005\u0006]\u0006\u0004\ra\\\u0001\naJLgnY5qC2\u0004\"\u0001]:\u000f\u0005E\t\u0018B\u0001:\u0013\u0003\u0019\u0001&/\u001a3fM&\u00111\u0005\u001e\u0006\u0003eJAQA^1A\u0002=\f1c\u001c8D_:4\u0017nZ;sCRLwN\\%uK6DQA\u0019\u001c\u0005\u0002a$B\u0001Z=\u0002\n!)!p\u001ea\u0001w\u0006!\u0011-\u001e;i!\ra\u0018QA\u0007\u0002{*\u0011ap`\u0001\u0005G>\u0014XMC\u0002\u0004\u0003\u0003Q1!a\u0001\\\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017bAA\u0004{\nq\u0011)\u001e;iK:$\u0018nY1uS>t\u0007\"\u0002<x\u0001\u0004y\u0007B\u000227\t\u0003\ti\u0001F\u0004e\u0003\u001f\t\t\"!\b\t\ri\fY\u00011\u0001|\u0011!\t\u0019\"a\u0003A\u0002\u0005U\u0011!\u0002:pY\u0016\u001c\b\u0003B3i\u0003/\u00012\u0001PA\r\u0013\r\tY\"\u0010\u0002\u0005%>dW\r\u0003\u0004w\u0003\u0017\u0001\ra\u001c\u0005\u0007EZ\"\t!!\t\u0015\u000f\u0011\f\u0019#!\f\u00020!A\u0011QEA\u0010\u0001\u0004\t9#\u0001\u0006qe&t7-\u001b9bYN\u0004B!ZA\u0015_&\u0019\u00111\u00064\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0003\u0005\u0002\u0014\u0005}\u0001\u0019AA\u000b\u0011\u00191\u0018q\u0004a\u0001_\"9\u00111\u0007\u001c\u0005\u0002\u0005U\u0012\u0001C4fiR+\u0017-\\:\u0015\u0007\u0011\f9\u0004\u0003\u0004w\u0003c\u0001\ra\u001c\u0005\b\u0003w1D\u0011AA\u001f\u0003)9(/\u001b;f)\u0016\fWn\u001d\u000b\u0007\u0003\u007f\t)%!\u0013\u0011\u0007E\t\t%C\u0002\u0002DI\u0011A!\u00168ji\"9\u0011qIA\u001d\u0001\u0004!\u0017!\u0002;fC6\u001c\bB\u0002<\u0002:\u0001\u0007q\u000eC\u0004\u0002NY\"I!a\u0014\u0002\u0013I,\u0017\r\u001a+fC6\u001cH\u0003BA)\u0003S\u0002R!a\u0015\u0002d)tA!!\u0016\u0002`9!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\)\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0007\u0005\u0005$#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\u0004'\u0016\f(bAA1%!A\u00111NA&\u0001\u0004\ti'\u0001\u0003o_\u0012,\u0007\u0003BA8\u0003oj!!!\u001d\u000b\u0007\u001d\u000b\u0019H\u0003\u0002\u0002v\u0005)!.\u0019<bq&!\u0011\u0011PA9\u0005\u0011qu\u000eZ3\t\u000f\u0005mb\u0007\"\u0003\u0002~Q1\u0011\u0011KA@\u0003\u0003C\u0001\"a\u001b\u0002|\u0001\u0007\u0011Q\u000e\u0005\t\u0003\u000f\nY\b1\u0001\u0002R!9\u0011Q\u0011\u001c\u0005\n\u0005\u001d\u0015a\u0004:fC\u0012$V-Y7O_\u0012,7o\u00144\u0015\t\u0005%\u00151\u0012\t\u0007\u0003'\n\u0019'!\u001c\t\u0011\u0005-\u00141\u0011a\u0001\u0003[Bq!a$7\t\u0013\t\t*A\tsK6|g/\u001a+fC6tu\u000eZ3t\u001f\u001a$B!a\u0010\u0002\u0014\"A\u00111NAG\u0001\u0004\ti\u0007C\u0004\u0002\u0018Z\"I!!'\u0002\u001d\u0005$G\rV3b[:{G-Z:U_R1\u0011qHAN\u0003;C\u0001\"a\u001b\u0002\u0016\u0002\u0007\u0011Q\u000e\u0005\t\u0003\u000f\n)\n1\u0001\u0002R!9\u0011\u0011\u0015\u001c\u0005\n\u0005\r\u0016\u0001\u0003:fC\u0012$V-Y7\u0015\u0007)\f)\u000b\u0003\u0005\u0002l\u0005}\u0005\u0019AA7\u0011\u001d\tIK\u000eC\u0005\u0003W\u000baB]8mK&#7\u000fV8OC6,7\u000f\u0006\u0003\u0002.\u0006=\u0006#BA*\u0003Gz\u0007\u0002CAY\u0003O\u0003\r!!,\u0002\u0011I|G.Z:JINDq!!.7\t\u0013\t9,\u0001\bs_2,g*Y7fgR{\u0017\nZ:\u0015\t\u00055\u0016\u0011\u0018\u0005\t\u0003w\u000b\u0019\f1\u0001\u0002.\u0006Q!o\u001c7fg:\u000bW.Z:\t\u000f\u0005}f\u0007\"\u0003\u0002B\u0006A!/Z1e\u001d>$W-\u0006\u0003\u0002D\u0006-G\u0003BAc\u0003O$B!a2\u0002^B!\u0011\u0011ZAf\u0019\u0001!\u0001\"!4\u0002>\n\u0007\u0011q\u001a\u0002\u0002)F!\u0011\u0011[Al!\r\t\u00121[\u0005\u0004\u0003+\u0014\"a\u0002(pi\"Lgn\u001a\t\u0004#\u0005e\u0017bAAn%\t\u0019\u0011I\\=\t\u0011\u0005}\u0017Q\u0018a\u0001\u0003C\f\u0001bY1mY\n\f7m\u001b\t\b#\u0005\r\u0018QNAd\u0013\r\t)O\u0005\u0002\n\rVt7\r^5p]FBq!!;\u0002>\u0002\u0007q.\u0001\u0002jI\"9\u0011Q\u001e\u001c\u0005\n\u0005=\u0018AC;qI\u0006$XMT8eKV!\u0011\u0011_A|)\u0011\t\u00190!@\u0015\t\u0005U\u0018\u0011 \t\u0005\u0003\u0013\f9\u0010\u0002\u0005\u0002N\u0006-(\u0019AAh\u0011!\ty.a;A\u0002\u0005m\bcB\t\u0002d\u00065\u0014Q\u001f\u0005\b\u0003S\fY\u000f1\u0001p\u0011\u001d\u0011\tA\u000eC\u0005\u0005\u0007\t!c^5uQ:{G-Z!oIN+7o]5p]V!!Q\u0001B\u0006)\u0011\u00119Aa\u0007\u0015\t\t%!Q\u0002\t\u0005\u0003\u0013\u0014Y\u0001\u0002\u0005\u0002N\u0006}(\u0019AAh\u0011!\ty.a@A\u0002\t=\u0001#C\t\u0003\u0012\u00055$Q\u0003B\u0005\u0013\r\u0011\u0019B\u0005\u0002\n\rVt7\r^5p]J\u0002B!a\u001c\u0003\u0018%!!\u0011DA9\u0005\u001d\u0019Vm]:j_:Dq!!;\u0002\u0000\u0002\u0007q\u000e")
public class JcrTeamService
implements TeamService {
    private final ScalaJcrTemplate jcrTemplate;
    private final RoleService roleService;
    private final Logger com$xebialabs$xlplatform$security$JcrTeamService$$logger;

    public static String TEAM_NODE_SEARCH_PATTERN() {
        return JcrTeamService$.MODULE$.TEAM_NODE_SEARCH_PATTERN();
    }

    public static String TEAM_NODE_PREFIX() {
        return JcrTeamService$.MODULE$.TEAM_NODE_PREFIX();
    }

    public static String PRINCIPALS_PROPERTY() {
        return JcrTeamService$.MODULE$.PRINCIPALS_PROPERTY();
    }

    public static String ROLES_PROPERTY() {
        return JcrTeamService$.MODULE$.ROLES_PROPERTY();
    }

    public static String NAME_PROPERTY() {
        return JcrTeamService$.MODULE$.NAME_PROPERTY();
    }

    public Logger com$xebialabs$xlplatform$security$JcrTeamService$$logger() {
        return this.com$xebialabs$xlplatform$security$JcrTeamService$$logger;
    }

    public List<Team> getTeamsFor(String principal, String onConfigurationItem) {
        return this.getTeamsFor(JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{principal}))), (List<Role>)this.roleService.getRolesFor(principal), onConfigurationItem);
    }

    public List<Team> getTeamsFor(Authentication auth, String onConfigurationItem) {
        return this.getTeamsFor(auth, (List<Role>)this.roleService.getRolesFor(auth), onConfigurationItem);
    }

    public List<Team> getTeamsFor(Authentication auth, List<Role> roles, String onConfigurationItem) {
        return this.getTeamsFor(Permissions.authenticationToPrincipals((Authentication)auth), roles, onConfigurationItem);
    }

    public List<Team> getTeamsFor(Collection<String> principals, List<Role> roles, String onConfigurationItem) {
        List<Team> teams = this.getTeams(onConfigurationItem);
        Buffer roleNames = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(roles).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Role x$1) {
                return x$1.getName();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(teams).filter((Function1)new Serializable(this, principals, roleNames){
            public static final long serialVersionUID = 0L;
            public final Collection principals$1;
            public final Buffer roleNames$1;

            public final boolean apply(Team team) {
                return JavaConversions$.MODULE$.asScalaBuffer(team.getPrincipals()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTeamsFor$1 $outer;

                    public final boolean apply(String x$2) {
                        return this.$outer.principals$1.contains(x$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }) || JavaConversions$.MODULE$.asScalaBuffer(team.getRoles()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTeamsFor$1 $outer;

                    public final boolean apply(String x$3) {
                        return this.$outer.roleNames$1.contains((Object)x$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.principals$1 = principals$1;
                this.roleNames$1 = roleNames$1;
            }
        }));
    }

    public List<Team> getTeams(String onConfigurationItem) {
        return (List)this.readNode(onConfigurationItem, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JcrTeamService $outer;

            public final List<Team> apply(Node node) {
                return JavaConversions$.MODULE$.seqAsJavaList(this.$outer.com$xebialabs$xlplatform$security$JcrTeamService$$readTeams(node));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void writeTeams(List<Team> teams, String onConfigurationItem) {
        this.updateNode(onConfigurationItem, (Function1)new Serializable(this, teams){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JcrTeamService $outer;
            private final List teams$1;

            public final Seq<Team> apply(Node node) {
                return this.$outer.com$xebialabs$xlplatform$security$JcrTeamService$$writeTeams(node, (Seq<Team>)JavaConversions$.MODULE$.asScalaBuffer(this.teams$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.teams$1 = teams$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Team> com$xebialabs$xlplatform$security$JcrTeamService$$readTeams(Node node) {
        void var2_2;
        this.com$xebialabs$xlplatform$security$JcrTeamService$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading teams from node [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getPath()})));
        Seq teams = (Seq)this.readTeamNodesOf(node).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JcrTeamService $outer;

            public final Team apply(Node node) {
                return this.$outer.com$xebialabs$xlplatform$security$JcrTeamService$$readTeam(node);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.com$xebialabs$xlplatform$security$JcrTeamService$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] teams read from node [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)teams.length()), node.getPath()})));
        return var2_2;
    }

    public Seq<Team> com$xebialabs$xlplatform$security$JcrTeamService$$writeTeams(Node node, Seq<Team> teams) {
        this.removeTeamNodesOf(node);
        this.addTeamNodesTo(node, teams);
        return this.com$xebialabs$xlplatform$security$JcrTeamService$$readTeams(node);
    }

    private Seq<Node> readTeamNodesOf(Node node) {
        return JavaConversions$.MODULE$.asScalaIterator((Iterator)node.getNodes(JcrTeamService$.MODULE$.TEAM_NODE_SEARCH_PATTERN())).toSeq();
    }

    private void removeTeamNodesOf(Node node) {
        this.com$xebialabs$xlplatform$security$JcrTeamService$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing teams from node [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getPath()})));
        this.readTeamNodesOf(node).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Node x$4) {
                x$4.remove();
            }
        });
    }

    private void addTeamNodesTo(Node node, Seq<Team> teams) {
        teams.foreach((Function1)new Serializable(this, node){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JcrTeamService $outer;
            private final Node node$1;

            public final Property apply(Team team) {
                this.$outer.com$xebialabs$xlplatform$security$JcrTeamService$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding team [", "] to node [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{team.getName(), this.node$1.getPath()})));
                String teamId = team.getId() == null || team.getId().isEmpty() ? JcrTeamService$.MODULE$.TEAM_NODE_PREFIX().concat(UUID.randomUUID().toString()) : team.getId();
                team.setId(teamId);
                Node teamNode = this.node$1.addNode(teamId);
                teamNode.setProperty(JcrTeamService$.MODULE$.NAME_PROPERTY(), team.getName());
                teamNode.setProperty(JcrTeamService$.MODULE$.PRINCIPALS_PROPERTY(), JcrPermissions.joinIds(team.getPrincipals()));
                return teamNode.setProperty(JcrTeamService$.MODULE$.ROLES_PROPERTY(), JcrPermissions.joinIds(JavaConversions$.MODULE$.seqAsJavaList(this.$outer.com$xebialabs$xlplatform$security$JcrTeamService$$roleNamesToIds((Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(team.getRoles())))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.node$1 = node$1;
            }
        });
    }

    public Team com$xebialabs$xlplatform$security$JcrTeamService$$readTeam(Node node) {
        String id = node.getName();
        String name = node.getProperty(JcrTeamService$.MODULE$.NAME_PROPERTY()).getString();
        Seq<String> roles = this.roleIdsToNames((Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(JcrPermissions.splitIds(node.getProperty(JcrTeamService$.MODULE$.ROLES_PROPERTY()).getString())));
        List<String> principals = JcrPermissions.splitIds(node.getProperty(JcrTeamService$.MODULE$.PRINCIPALS_PROPERTY()).getString());
        return new Team(id, name, JavaConversions$.MODULE$.seqAsJavaList(roles), principals);
    }

    private Seq<String> roleIdsToNames(Seq<String> rolesIds) {
        Map<String, Role> rolesById = JcrPermissions.buildLookupById(this.roleService.getRoles());
        Role missingRole = new Role(null);
        return (Seq)((TraversableLike)rolesIds.map((Function1)new Serializable(this, rolesById, missingRole){
            public static final long serialVersionUID = 0L;
            private final Map rolesById$1;
            private final Role missingRole$1;

            public final String apply(String roleId) {
                return this.rolesById$1.getOrDefault(roleId, this.missingRole$1).getName();
            }
            {
                this.rolesById$1 = rolesById$1;
                this.missingRole$1 = missingRole$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(this, missingRole){
            public static final long serialVersionUID = 0L;
            private final Role missingRole$1;

            public final boolean apply(String x$5) {
                String string = x$5;
                String string2 = this.missingRole$1.getName();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.missingRole$1 = missingRole$1;
            }
        });
    }

    public Seq<String> com$xebialabs$xlplatform$security$JcrTeamService$$roleNamesToIds(Seq<String> rolesNames) {
        Map<String, Role> rolesByName = JcrPermissions.buildLookupByName(this.roleService.getRoles());
        return (Seq)rolesNames.map((Function1)new Serializable(this, rolesByName){
            public static final long serialVersionUID = 0L;
            private final Map rolesByName$1;

            public final String apply(String roleName) {
                Checks.checkArgument((boolean)this.rolesByName$1.containsKey(roleName), (String)"Role [%s] not found", (Object[])new Object[]{roleName});
                return ((Role)this.rolesByName$1.get(roleName)).getId();
            }
            {
                this.rolesByName$1 = rolesByName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private <T> T readNode(String id, Function1<Node, T> callback) {
        return this.withNodeAndSession(id, (Function2<Node, Session, T>)new Serializable(this, callback){
            public static final long serialVersionUID = 0L;
            private final Function1 callback$1;

            public final T apply(Node node, Session session) {
                return (T)this.callback$1.apply((Object)node);
            }
            {
                this.callback$1 = callback$1;
            }
        });
    }

    private <T> T updateNode(String id, Function1<Node, T> callback) {
        return this.withNodeAndSession(id, (Function2<Node, Session, T>)new Serializable(this, callback){
            public static final long serialVersionUID = 0L;
            private final Function1 callback$2;

            /*
             * WARNING - void declaration
             */
            public final T apply(Node node, Session session) {
                void var3_3;
                Object result = this.callback$2.apply((Object)node);
                session.save();
                return var3_3;
            }
            {
                this.callback$2 = callback$2;
            }
        });
    }

    private <T> T withNodeAndSession(String id, Function2<Node, Session, T> callback) {
        return (T)this.jcrTemplate.execute((Function1)new Serializable(this, id, callback){
            public static final long serialVersionUID = 0L;
            public final String id$1;
            private final Function2 callback$3;

            public final T apply(Session session) {
                Success success;
                Node userNode;
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, session){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$withNodeAndSession$1 $outer;
                    private final Session session$1;

                    public final Node apply() {
                        return this.session$1.getNode(JcrPathHelper.getAbsolutePathFromId((String)this.$outer.id$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.session$1 = session$1;
                    }
                });
                if (try_ instanceof Success && (userNode = (Node)(success = (Success)try_).value()) != null) {
                    Node node = userNode;
                    Object object = this.callback$3.apply((Object)node, (Object)session);
                    return (T)object;
                }
                if (try_ instanceof Failure) {
                    throw new NotFoundException("Configuration item [%s] not found", new Object[]{this.id$1});
                }
                throw new MatchError((Object)try_);
            }
            {
                this.id$1 = id$1;
                this.callback$3 = callback$3;
            }
        });
    }

    public JcrTeamService(ScalaJcrTemplate jcrTemplate, RoleService roleService) {
        this.jcrTemplate = jcrTemplate;
        this.roleService = roleService;
        this.com$xebialabs$xlplatform$security$JcrTeamService$$logger = LoggerFactory.getLogger(JcrTeamService.class);
    }
}

