/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.JcrUser;
import com.xebialabs.deployit.security.UserService;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrUserService
implements UserService {
    @Autowired
    private JcrTemplate jcrTemplate;

    public void create(final String username, final String password) {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

            public Object doInJcr(Session session) throws RepositoryException {
                UserManager um = ((JackrabbitSession)session).getUserManager();
                um.createUser(username, password);
                return null;
            }
        });
    }

    public JcrUser read(final String username) {
        return (JcrUser)this.jcrTemplate.execute((JcrCallback)new JcrCallback<JcrUser>(){

            public JcrUser doInJcr(Session session) throws RepositoryException {
                User u = JcrUserService.this.getUser(username, session);
                return new JcrUser(u.getID(), u.isAdmin());
            }
        });
    }

    public void modifyPassword(final String username, final String newPassword) {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

            public Object doInJcr(Session session) throws RepositoryException {
                User u = JcrUserService.this.getUser(username, session);
                u.changePassword(newPassword);
                return null;
            }
        });
    }

    public void modifyPassword(final String username, final String newPassword, final String oldPassword) {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

            public Object doInJcr(Session session) throws RepositoryException {
                User u = JcrUserService.this.getUser(username, session);
                u.changePassword(newPassword, oldPassword);
                return null;
            }
        });
    }

    public void delete(final String username) {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

            public Object doInJcr(Session session) throws RepositoryException {
                User u = JcrUserService.this.getUser(username, session);
                u.remove();
                return null;
            }
        });
    }

    private User getUser(String username, Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        UserManager um = ((JackrabbitSession)session).getUserManager();
        Authorizable authorizable = um.getAuthorizable(username);
        if (authorizable == null) {
            throw new NotFoundException("No such user: " + username, new Object[0]);
        }
        if (authorizable.isGroup()) {
            throw new IllegalStateException("Principal " + username + " is not a user");
        }
        User u = (User)authorizable;
        return u;
    }
}

