package com.xebialabs.deployit.core;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;


@SuppressWarnings("serial")
public class SetOfStringView extends AbstractStringView<Set<StringValue>> implements Set<String> {
    public SetOfStringView() {
        super(new HashSet<>());
    }

    public SetOfStringView(Set<StringValue> wrapped) {
        super(wrapped);
    }

    @Override
    public SetOfStringView encrypt() {
        return new SetOfStringView(wrapped.stream().map(StringValue::encrypt).collect(Collectors.toSet()));
    }

    public static SetOfStringView from(Set<String> strings) {
        if (strings instanceof SetOfStringView) {
            return (SetOfStringView) strings;
        } else {
            SetOfStringView stringView = new SetOfStringView();
            if (strings != null) {
                stringView.addAll(strings);
            }
            return stringView;
        }
    }

    public static SetOfStringView copy(Set<String> strings) {
        if (strings instanceof SetOfStringView) {
            return new SetOfStringView(new HashSet<>(((SetOfStringView) strings).getWrapped()));
        } else {
            return from(strings);
        }
    }
}
