/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.validator;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import com.xebialabs.xlplatform.security.validator.Invalid;
import com.xebialabs.xlplatform.security.validator.StringValidator;
import com.xebialabs.xlplatform.security.validator.Valid;
import com.xebialabs.xlplatform.security.validator.ValidationResult;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0006\r\u0001]A\u0001B\b\u0001\u0003\u0006\u0004%\ta\b\u0005\tQ\u0001\u0011\t\u0011)A\u0005A!)\u0011\u0006\u0001C\u0001U!)Q\b\u0001C\u0001}!)Q\n\u0001C\u0001\u001d\")\u0001\u000b\u0001C\u0001#\")\u0001\u000b\u0001C\u0001'\")\u0011\r\u0001C\u0001E\")!\u000f\u0001C\u0001g\")\u0001\u0010\u0001C\u0001s\niQk]3s-\u0006d\u0017\u000eZ1u_JT!!\u0004\b\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\b\u0011\u0003!\u0019XmY;sSRL(BA\t\u0013\u0003!!W\r\u001d7ps&$(BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0012a\u0006\u001c8o^8sIZ\u000bG.\u001b3bi>\u0014X#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u00055\u0019#BA\b%\u0015\t)##\u0001\u0006yYBd\u0017\r\u001e4pe6L!a\n\u0012\u0003\u001fM#(/\u001b8h-\u0006d\u0017\u000eZ1u_J\f!\u0003]1tg^|'\u000f\u001a,bY&$\u0017\r^8sA\u00051A(\u001b8jiz\"\"aK\u0017\u0011\u00051\u0002Q\"\u0001\u0007\t\u000by\u0019\u0001\u0019\u0001\u0011)\u0005\ry\u0003C\u0001\u0019<\u001b\u0005\t$B\u0001\u001a4\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003iU\nqAZ1di>\u0014\u0018P\u0003\u00027o\u0005)!-Z1og*\u0011\u0001(O\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!(A\u0002pe\u001eL!\u0001P\u0019\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!B2iK\u000e\\GCA C!\tI\u0002)\u0003\u0002B5\t!QK\\5u\u0011\u0015\u0019E\u00011\u0001E\u0003\u0011)8/\u001a:\u0011\u0005\u0015[U\"\u0001$\u000b\u0005=9%B\u0001%J\u0003\r\t\u0007/\u001b\u0006\u0003\u0015B\ta!\u001a8hS:,\u0017B\u0001'G\u0005\u0011)6/\u001a:\u0002\u001b\rDWmY6Vg\u0016\u0014h*Y7f)\tyt\nC\u0003D\u000b\u0001\u0007A)A\u0007dQ\u0016\u001c7\u000eU1tg^|'\u000f\u001a\u000b\u0003\u007fICQa\u0011\u0004A\u0002\u0011#\"a\u0010+\t\u000bU;\u0001\u0019\u0001,\u0002\u0011A\f7o]<pe\u0012\u0004\"a\u00160\u000f\u0005ac\u0006CA-\u001b\u001b\u0005Q&BA.\u0017\u0003\u0019a$o\\8u}%\u0011QLG\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^5\u0005\u0001b/\u00197jI\u0006$X\rU1tg^|'\u000f\u001a\u000b\u0003GF\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003\u0011)H/\u001b7\u000b\u0003!\fAA[1wC&\u0011!.\u001a\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002m_6\tQN\u0003\u0002oG\u0005\u0019A\r^8\n\u0005Al'\u0001\u0007)bgN<xN\u001d3WC2LG-\u0019;j_:\u0014Vm];mi\")Q\u000b\u0003a\u0001-\u0006q1\r[3dW6\u000b\u0007\u0010T3oORDGcA um\")Q/\u0003a\u0001-\u0006\u0019Qn]4\t\u000b]L\u0001\u0019\u0001,\u0002\u000b\u0019LW\r\u001c3\u0002#\rDWmY6JgZ\u000bG.\u001b3F[\u0006LG\u000e\u0006\u0002@u\")1P\u0003a\u0001-\u0006)Q-\\1jY\"\u0012\u0001! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005q'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L1!!\u0002\u0000\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class UserValidator {
    private final StringValidator passwordValidator;

    public StringValidator passwordValidator() {
        return this.passwordValidator;
    }

    public void check(User user) {
        Checks.checkNotNull((Object)user, (String)"User can not be null.", (Object[])new Object[]{""});
        this.checkUserName(user);
        this.checkPassword(user);
    }

    public void checkUserName(User user) {
        Checks.checkArgument((!StringUtils.isBlank((String)user.getUsername()) ? 1 : 0) != 0, (String)"User name cannot be empty.", (Object[])new Object[0]);
        Pattern pattern = Pattern.compile("^(?![\\.\\-_])(?!.*[\\.\\-_]{2})[\\w\\.\\-_]*[^\\W_]$", 256);
        Matcher matcher = pattern.matcher(user.getUsername());
        Checks.checkArgument((boolean)matcher.matches(), (String)"All the alphanumeric characters and the special characters dash (-), underscore (_), and dot (.) are allowed. The special characters cannot be repeated more than once in a row. The username must not start or end with a special character.", (Object[])new Object[0]);
    }

    public void checkPassword(User user) {
        Checks.checkArgument((!StringUtils.isBlank((String)user.getPassword()) ? 1 : 0) != 0, (String)"Password is required when creating a user.", (Object[])new Object[0]);
        this.checkPassword(user.getPassword());
    }

    public void checkPassword(String password) {
        List invalids = this.passwordValidator().validate(password).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserValidator.$anonfun$checkPassword$1(x$1)));
        if (invalids.nonEmpty()) {
            throw new Checks.IncorrectArgumentException(((IterableOnceOps)new .colon.colon((Object)"Password needs to meet following requirements:", (List)Nil$.MODULE$).$plus$plus((IterableOnce)invalids.map((Function1 & Serializable)x$2 -> x$2.message()))).mkString(System.lineSeparator() + "\t"), new Object[0]);
        }
    }

    public java.util.List<PasswordValidationResult> validatePassword(String password) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.passwordValidator().validate(password).map((Function1 & Serializable)vr -> new PasswordValidationResult(vr instanceof Valid, vr.message())).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isValid()), Ordering.Boolean$.MODULE$.reverse())).asJava();
    }

    public void checkMaxLength(String msg, String field) {
        Checks.checkArgument((msg.length() <= 255 ? 1 : 0) != 0, (String)("Maximum allowed length for the " + field + " is 255 characters. Provide an entry with fewer characters."), (Object[])new Object[0]);
    }

    public void checkIsValidEmail(String email) {
        Regex emailPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[A-Za-z0-9_%+-]+(?:\\.[A-Za-z0-9_%+-]+)?@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,6})$"));
        Checks.checkArgument((boolean)emailPattern.matches((CharSequence)email), (String)("The email address " + email + " is invalid. Provide a valid email address."), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$checkPassword$1(ValidationResult x$1) {
        return x$1 instanceof Invalid;
    }

    @Autowired
    public UserValidator(StringValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }
}

