package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;

/**
 * This exception should be thrown when trying to create a user with a principal which already exists in the repository.
 */

@SuppressWarnings("serial")
@HttpResponseCodeResult(statusCode = 409)
public class UserAlreadyExistsException extends DeployitException {

    public UserAlreadyExistsException(String username) {
        super(String.format("The username [%s] is already in use. Choose a unique username.", username));
    }
}
