package com.xebialabs.deployit.security;

import java.util.ArrayList;
import java.util.List;

import static java.util.Arrays.asList;

public class Role {
    private String id;
    private String name;

    private List<String> principals = new ArrayList<>();
    private List<String> roles = new ArrayList<>();

    public Role(String id, String name, List<String> principals, List<String> roles) {
        this(id, name, principals);
        this.roles = new ArrayList<>(roles);
    }

    public Role(String id, String name, List<String> principals) {
        this(id, name);
        this.principals = new ArrayList<>(principals);
    }

    public Role(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public Role(String name) {
        this(null, name);
    }

    ////

    public Role withPrincipals(String... newPrincipals) {
        setPrincipals(new ArrayList<>(asList(newPrincipals)));
        return this;
    }

    public Role withRoles(String... newRoles) {
        setRoles(new ArrayList<>(asList(newRoles)));
        return this;
    }

    ////

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrincipals(final List<String> principals) {
        this.principals = principals;
    }

    // backwards compatible
    @Deprecated
    public List<String> getPrincipalsAssigned() {
        return getPrincipals();
    }

    public List<String> getPrincipals() {
        return principals;
    }

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(final List<String> roles) {
        this.roles = roles;
    }

    @Override
    public String toString() {
        return name;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Role) {
            Role o = (Role) obj;
            return (id == null && o.id == null) ? name.equals(o.name) : (id != null && id.equals(o.id));
        }
        return false;
    }
}
