package com.xebialabs.deployit.security;


import java.util.List;

import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;

public interface UserService {

    void create(final String username, final String password);

    User read(final String username);

    List<String> listUsernames();

    void modifyPassword(final String username, final String newPassword);

    /**
     * @throws IllegalArgumentException when the provided old password does not match
     */
    void modifyPassword(final String username, final String newPassword, final String oldPassword) throws IllegalArgumentException;

    void delete(final String username);

    void authenticate(final String username, final String password) throws AuthenticationFailureException;

}