package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.spi.exception.SuppressStackTrace;

@SuppressWarnings("serial")
@HttpResponseCodeResult(statusCode = 401)
@SuppressStackTrace(suppressStackTrace = true)
public class AuthenticationFailureException extends DeployitException {

    public AuthenticationFailureException() {
        super("Not logged in");
    }

    public AuthenticationFailureException(String message) {
        super(message);
    }

    public AuthenticationFailureException(String messageTemplate, Object... params) {
        super(messageTemplate, params);
    }

    public AuthenticationFailureException(Throwable cause) {
        super(cause);
    }

    public AuthenticationFailureException(Throwable cause, String messageTemplate, Object... params) {
        super(cause, messageTemplate, params);
    }

}
