package com.xebialabs.xlplatform.security.validator

trait Validation[T] {
  def validate(input: T): Boolean

  val message: String
}

trait ValidationResult {
  val message: String
}

case class Invalid(override val message: String) extends ValidationResult

case class Valid(override val message: String) extends ValidationResult

trait Validator[T] {
  val validators: List[Validation[T]]

  def validate(input: T): List[ValidationResult] = validators.map(validation => if (validation.validate(input)) {
    Valid(validation.message)
  } else {
    Invalid(validation.message)
  })
}

trait StringValidator extends Validator[String]
