package com.xebialabs.platform.script

import javax.script.{ScriptContext, SimpleScriptContext}

package object jython {

  implicit class ScriptContextUtils(variables: Map[String, Any]) {
    def toScriptContext = {
      val scriptContext: SimpleScriptContext = new SimpleScriptContext()
      variables.foreach { case (name, value) => scriptContext.setAttribute(name, value, ScriptContext.ENGINE_SCOPE)}
      scriptContext
    }
  }
}
