package com.xebialabs.platform.script.jython

import javax.script.ScriptContext

object JythonContext {

  def apply(library: ScriptSource, bindings: Map[String, Any]): JythonContext = JythonContext(Iterable(library), bindings)

  def apply(libraries: Iterable[ScriptSource] = Nil, bindings: Map[String, Any] = Map.empty[String, Any]): JythonContext = {
    JythonContext.withLibrariesAndFactory(libraries) { bindings.toScriptContext }
  }

  def withLibrariesAndFactory(libraries: Iterable[ScriptSource] = Nil)(scriptContextFactory: => ScriptContext): JythonContext = new JythonContext(libraries, scriptContextFactory)
}

class JythonContext(val libraries: Iterable[ScriptSource], scriptContextFactory: => ScriptContext) {
  def buildScriptContext = scriptContextFactory
}
