package com.xebialabs.platform.script.jython

import java.io.{PrintWriter, StringWriter}

import com.xebialabs.deployit.local.message.ProductName
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, ITask}
import grizzled.slf4j.Logging

class JythonExecutionContext extends ExecutionContext with Logging {

  private val logBuilder = new StringBuilder
  private val ERROR_PREFIX = "[ERROR]: "

  override def logOutput(output: String): Unit = {
    logOutputRaw(output + "\n")
  }

  override def logMsgOutput(productName: ProductName, key: String, args: Object*): Unit = {
    val output = getMessage(productName, key, args: _*)
    logOutputRaw(output + "\n")
  }

  override def logOutputRaw(output: String): Unit = {
    logger.info(output.stripSuffix("\n"))
    logBuilder.append(output)
  }

  override def logError(error: String): Unit = {
    logErrorRaw(error + "\n")
  }

  override def logErrorRaw(error: String): Unit = {
    logErrorRaw(error, None)
  }

  def logError(error: String, t: Throwable): Unit = {
    logErrorRaw(error + "\n", Option(t))
  }

  private def logErrorRaw(error: String, t: Option[Throwable]): Unit = {
    t match {
      case Some(err) =>
        logger.error(error.stripSuffix("\n"), err)
        appendErrorToLogRaw(error)
        logException(err)
      case _ =>
        logger.error(error.stripSuffix("\n"))
        appendErrorToLogRaw(error)
    }
  }

  private def appendErrorToLogRaw(error: String): Unit = {
    logBuilder.append(ERROR_PREFIX).append(error)
  }

  private def logException(t: Throwable): Unit = {
    val stringWriter: StringWriter = new StringWriter
    t.printStackTrace(new PrintWriter(stringWriter))
    stringWriter.toString.split("\n").foreach(s => logBuilder.append(ERROR_PREFIX).append(s).append("\n"))
  }

  override def getAttribute(name: String) = throw new UnsupportedOperationException

  override def setAttribute(name: String, value: Any): Unit = throw new UnsupportedOperationException

  override def getRepository = throw new UnsupportedOperationException

  override def getInspectionContext = throw new UnsupportedOperationException

  override def getTask: ITask = throw new UnsupportedOperationException

  def getLog: String = logBuilder.toString

}
