package com.xebialabs.platform.script.jython

import javax.script.{ScriptException, ScriptContext}
import com.xebialabs.platform.script.jython.JythonSupport.PreprocessExpression
import grizzled.slf4j.Logging

object JythonSupport {
  type PreprocessExpression = String => String
}

trait JythonSupport extends Logging{
  import EngineInstance._

  private val doNotPreprocess : PreprocessExpression = expr => expr

  def evaluateExpression[T](expression: String, preprocess : PreprocessExpression = doNotPreprocess)(implicit jythonContext: JythonContext): T = {
    require(Option(expression).filter(_.nonEmpty).isDefined, "Expression must be defined")
    val result = executeScript(ScriptSource.byContent(preprocess(expression)))
    result.asInstanceOf[T]
  }

  def executeScript(scriptSource: ScriptSource)(implicit jythonContext: JythonContext): AnyRef = {
    val scriptContext = jythonContext.buildScriptContext
    jythonContext.libraries.foreach(runtimeScript =>
      executeScript(runtimeScript, scriptContext)
    )
    executeScript(scriptSource, scriptContext)
  }

  def executeScript(scriptSource: ScriptSource, scriptContext: ScriptContext): AnyRef = {
    trace(s"Evaluating script\n${scriptSource.scriptContent}")
    try {
      jython.eval(scriptSource.scriptContent, scriptContext)
    } catch {
      case ex: ScriptException => throw JythonException(scriptSource, ex)
    }
  }
}
