package com.xebialabs.platform.script.jython

import scala.io.Source
import scala.util.Try
import java.net.URL

sealed trait ScriptSource {
  def scriptContent: String
}

object ScriptSource {
  def byUrl(url: URL): ScriptSource = new UrlScriptSource(url)
  def byResource(resource: String): ScriptSource = new ResourceScriptSource(resource)
  def byContent(content: String): ScriptSource = new ContentScriptSource(content)
}

private[jython] class ContentScriptSource(content: String) extends ScriptSource {
  override def scriptContent = content
}

private[jython] class UrlScriptSource(val url: URL) extends ScriptSource {
  override def scriptContent = Try(Source.fromURL(url))
    .getOrElse(throw new IllegalArgumentException(s"$url does not exist")).mkString
}

private[jython] class ResourceScriptSource(val resource: String) extends ScriptSource {
  override def scriptContent = Try(Source.fromURL(getClass.getClassLoader.getResource(resource)))
    .getOrElse(throw new IllegalArgumentException(s"$resource does not exist")).mkString
}
