package com.xebialabs.platform.script.jython

import java.io.{IOException, Writer}

import scala.collection.mutable

/**
 * Since there is an unexpected behaviour when running multiple script engines in parallel : http://bugs.jython.org/issue2154
 * We have to resort to a StringWriter sub-class which delegates to a StringWriter found using a ThreadLocal container.
 *
 * MW=20170712: The issue referenced above is marked resolved, but our tests still indicate the problem is not fixed.
 */
class ThreadLocalWriterDecorator() extends Writer {

  val threadLocal: ThreadLocal[mutable.Stack[Writer]] = ThreadLocal.withInitial(() => new mutable.Stack[Writer])

  def registerWriter(writer: Writer): Unit = threadLocal.get.push(writer)

  def removeWriter(): Unit = threadLocal.get.pop()

  def getWriter: Writer = threadLocal.get.head

  @throws(classOf[IOException])
  def write(cbuf: Array[Char], off: Int, len: Int): Unit = getWriter.write(cbuf, off, len)

  @throws(classOf[IOException])
  def flush(): Unit = getWriter.flush()

  @throws(classOf[IOException])
  def close(): Unit = getWriter.close()

  override def toString: String = getWriter.toString
}
