/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.scheduler;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.CisUpdatedEvent;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStoppedEvent;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlplatform.scheduler.ActorJob;
import com.xebialabs.xlplatform.scheduler.ControlTaskExecutor;
import com.xebialabs.xlplatform.scheduler.Scheduler;
import com.xebialabs.xlplatform.scheduler.SchedulerActorSystem$;
import com.xebialabs.xlplatform.scheduler.ci.ControlTaskInvokable;
import com.xebialabs.xlplatform.scheduler.ci.ScheduledJob;
import com.xebialabs.xlplatform.scheduler.spring.ServiceHolder;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.List;
import nl.javadude.t2bus.Subscribe;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.convert.WrapAsScala;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeployitEventListener
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001-\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005Q\u0001\u0010\u001c9mCR4wN]7\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\u000bMdg\r\u000e6\u000b\u0003]\t\u0001b\u001a:jujdW\rZ\u0005\u00033Q\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0015\r\u0011\"\u0001\u001c+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0015\t7\r^8s\u0015\u0005\t\u0013\u0001B1lW\u0006L!a\t\u0010\u0003\u0011\u0005\u001bGo\u001c:SK\u001aD\u0001\"\n\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002'\r|g\u000e\u001e:pYR\u000b7o[#yK\u000e,Ho\u001c:\t\u0011%\u0002!\u0011!Q\u0001\nq\tAcY8oiJ|G\u000eV1tW\u0016CXmY;u_J\u0004\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\u0002#I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0006sKB|7/\u001b;pefT!A\r\u0004\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001N\u0018\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\r\u0003\u00057\u0001\t\u0005\t\u0015!\u0003.\u0003I\u0011X\r]8tSR|'/_*feZL7-\u001a\u0011\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0011QD(\u0010 \u0011\u0005m\u0002Q\"\u0001\u0002\t\u000b\r9\u0004\u0019\u0001\u000f\t\u000b\u001d:\u0004\u0019\u0001\u000f\t\u000b-:\u0004\u0019A\u0017\t\u000ba\u0002A\u0011\u0001!\u0015\u0003iBqA\u0011\u0001C\u0002\u0013\r1)A\u0006bGR|'oU=ti\u0016lW#\u0001#\u0011\u0005u)\u0015B\u0001$\u001f\u0005-\t5\r^8s'f\u001cH/Z7\t\r!\u0003\u0001\u0015!\u0003E\u00031\t7\r^8s'f\u001cH/Z7!\u0011\u001dQ\u0005A1A\u0005\u0004-\u000b\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002R\u001d\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\t\rM\u0003\u0001\u0015!\u0003M\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\t\u0005\u0006+\u0002!\tAV\u0001\u0013e\u0016\u001cW-\u001b<f'f\u001cH/Z7Ti\u0006\u0014H\u000f\u0006\u0002X5B\u0011Q\u0002W\u0005\u00033:\u0011A!\u00168ji\")1\f\u0016a\u00019\u0006)QM^3oiB\u0011QlY\u0007\u0002=*\u00111l\u0018\u0006\u0003A\u0006\f1a\u001d9j\u0015\t\u0011\u0017'\u0001\u0004f]\u001eLg.Z\u0005\u0003Iz\u0013!cU=ti\u0016l7\u000b^1si\u0016$WI^3oi\"\u0012AK\u001a\t\u0003O:l\u0011\u0001\u001b\u0006\u0003S*\fQ\u0001\u001e\u001ackNT!a\u001b7\u0002\u0011)\fg/\u00193vI\u0016T\u0011!\\\u0001\u0003]2L!a\u001c5\u0003\u0013M+(m]2sS\n,\u0007\"B9\u0001\t\u0003\u0011\u0018!\u0005:fG\u0016Lg/Z\"jg\u000e\u0013X-\u0019;fIR\u0011qk\u001d\u0005\u00067B\u0004\r\u0001\u001e\t\u0003;VL!A\u001e0\u0003\u001f\rK7o\u0011:fCR,G-\u0012<f]RD#\u0001\u001d4\t\u000be\u0004A\u0011\u0001>\u0002#I,7-Z5wK\u000eK7/\u00169eCR,G\r\u0006\u0002Xw\")1\f\u001fa\u0001yB\u0011Q,`\u0005\u0003}z\u0013qbQ5t+B$\u0017\r^3e\u000bZ,g\u000e\u001e\u0015\u0003q\u001aDq!a\u0001\u0001\t\u0003\t)!A\tsK\u000e,\u0017N^3DSN$U\r\\3uK\u0012$2aVA\u0004\u0011\u001dY\u0016\u0011\u0001a\u0001\u0003\u0013\u00012!XA\u0006\u0013\r\tiA\u0018\u0002\u0010\u0007&\u001cH)\u001a7fi\u0016$WI^3oi\"\u001a\u0011\u0011\u00014\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005\t\"/Z2fSZ,7+_:uK6\u001cFo\u001c9\u0015\u0007]\u000b9\u0002C\u0004\\\u0003#\u0001\r!!\u0007\u0011\u0007u\u000bY\"C\u0002\u0002\u001ey\u0013!cU=ti\u0016l7\u000b^8qa\u0016$WI^3oi\"\u001a\u0011\u0011\u00034\t\u0011\u0005\r\u0002\u0001\"\u0001\u0003\u0003K\t\u0011BZ5mi\u0016\u00148)[:\u0016\t\u0005\u001d\u0012q\b\u000b\u0005\u0003S\ty\u0007\u0006\u0003\u0002,\u0005}\u0003CBA\u0017\u0003o\tY$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\u001diW\u000f^1cY\u0016T1!!\u000e\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\tyC\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003{\ty\u0004\u0004\u0001\u0005\u0011\u0005\u0005\u0013\u0011\u0005b\u0001\u0003\u0007\u0012\u0011\u0001V\t\u0005\u0003\u000b\nY\u0005E\u0002\u000e\u0003\u000fJ1!!\u0013\u000f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0014\u0002\\5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0002vI6TA!!\u0016\u0002X\u0005\u0019\u0011\r]5\u000b\u0007\u0005e\u0013'\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0003;\nyEA\tD_:4\u0017nZ;sCRLwN\\%uK6D\u0001\"!\u0019\u0002\"\u0001\u000f\u00111M\u0001\u0003GR\u0004b!!\u001a\u0002l\u0005mRBAA4\u0015\r\tIGD\u0001\be\u00164G.Z2u\u0013\u0011\ti'a\u001a\u0003\u0011\rc\u0017m]:UC\u001eDqaWA\u0011\u0001\u0004\t\t\bE\u0002^\u0003gJ1!!\u001e_\u0005-\u0019\u0015NQ1tK\u00163XM\u001c;\t\u0011\u0005e\u0004\u0001\"\u0001\u0003\u0003w\n!B]3ti\u0006\u0014HOS8c)\r9\u0016Q\u0010\u0005\t\u0003\u007f\n9\b1\u0001\u0002\u0002\u0006\u0019!n\u001c2\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"\u0003\u0003\t\u0019\u0017.\u0003\u0003\u0002\f\u0006\u0015%\u0001D*dQ\u0016$W\u000f\\3e\u0015>\u0014\u0007\u0002CAH\u0001\u0011\u0005!!!%\u0002\u0011M$\u0018M\u001d;K_\n$2aVAJ\u0011!\ty(!$A\u0002\u0005\u0005\u0005\u0002CAL\u0001\u0011\u0005!!!'\u0002\u000fM$x\u000e\u001d&pER\u0019q+a'\t\u0011\u0005}\u0014Q\u0013a\u0001\u0003\u0003C3\u0001AAP!\ri\u0016\u0011U\u0005\u0004\u0003Gs&!\u0006#fa2|\u00170\u001b;Fm\u0016tG\u000fT5ti\u0016tWM\u001d")
public class EventListener
implements Logging {
    private final ActorRef scheduler;
    private final ActorRef controlTaskExecutor;
    private final RepositoryService repositoryService;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor executionContext;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EventListener eventListener = this;
        synchronized (eventListener) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public ActorRef scheduler() {
        return this.scheduler;
    }

    public ActorRef controlTaskExecutor() {
        return this.controlTaskExecutor;
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    @Subscribe
    public void receiveSystemStart(SystemStartedEvent event) {
        this.logger().debug((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting scheduled control task jobs";
            }
        });
        Type scheduledJobType = Type.valueOf(ScheduledJob.class);
        this.logger().debug((Function0)new Serializable(this, scheduledJobType){
            public static final long serialVersionUID = 0L;
            private final Type scheduledJobType$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching all nodes of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.scheduledJobType$1}));
            }
            {
                this.scheduledJobType$1 = scheduledJobType$1;
            }
        });
        List cis = this.repositoryService().list(new SearchParameters().setType(scheduledJobType).setAncestor(Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName()).setResultsPerPage(-1L));
        this.logger().debug((Function0)new Serializable(this, cis){
            public static final long serialVersionUID = 0L;
            private final List cis$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " jobs matching criteria"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.cis$1.size())}));
            }
            {
                this.cis$1 = cis$1;
            }
        });
        ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaBuffer(cis).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EventListener $outer;

            public final void apply(ConfigurationItemData cid) {
                this.$outer.startJob((ScheduledJob)this.$outer.repositoryService().read(cid.getId()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Subscribe
    public void receiveCisCreated(CisCreatedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EventListener $outer;

            public final void apply(ScheduledJob job) {
                this.$outer.startJob(job);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Subscribe
    public void receiveCisUpdated(CisUpdatedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EventListener $outer;

            public final void apply(ScheduledJob job) {
                this.$outer.restartJob(job);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Subscribe
    public void receiveCisDeleted(CisDeletedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EventListener $outer;

            public final void apply(ScheduledJob job) {
                this.$outer.stopJob(job);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Subscribe
    public void receiveSystemStop(SystemStoppedEvent event) {
        this.logger().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping scheduled control task jobs";
            }
        });
        SchedulerActorSystem$.MODULE$.shutdownTheSystem();
    }

    public <T extends ConfigurationItem> Buffer<T> filterCis(CiBaseEvent event, ClassTag<T> ct) {
        return (Buffer)((TraversableLike)((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).asScalaBuffer(event.getCis()).filter((Function1)new Serializable(this, ct){
            public static final long serialVersionUID = 0L;
            private final ClassTag ct$1;

            public final boolean apply(ConfigurationItem x$1) {
                return x$1.getType().isSubTypeOf(Type.valueOf((Class)this.ct$1.runtimeClass()));
            }
            {
                this.ct$1 = ct$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(ConfigurationItem x$2) {
                return (T)x$2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public void restartJob(ScheduledJob job) {
        this.stopJob(job);
        this.startJob(job);
    }

    public void startJob(ScheduledJob job) {
        if (job.enabled()) {
            ScheduledJob scheduledJob = job;
            if (scheduledJob instanceof ControlTaskInvokable) {
                ControlTaskExecutor.Messages.InvokeControlTask invokeControlTask;
                ScheduledJob scheduledJob2 = scheduledJob;
                ControlTaskExecutor.Messages.InvokeControlTask message = invokeControlTask = new ControlTaskExecutor.Messages.InvokeControlTask(((ControlTaskInvokable)((Object)scheduledJob2)).getConfigurationItemId(), ((ControlTaskInvokable)((Object)scheduledJob2)).getControlTaskName(), ((ControlTaskInvokable)((Object)scheduledJob2)).getControlTaskParams());
                ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.scheduler());
                Scheduler.Messages.ScheduleJob x$3 = new Scheduler.Messages.ScheduleJob(new ActorJob(job.getId(), this.controlTaskExecutor(), message), job.getTrigger());
                ActorRef x$4 = qual$1.$bang$default$2((Object)x$3);
                qual$1.$bang((Object)x$3, x$4);
            } else {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to schedule unknown job ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job})));
            }
        }
    }

    public void stopJob(ScheduledJob job) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.scheduler());
        Scheduler.Messages.CancelJob x$5 = new Scheduler.Messages.CancelJob(job.getId());
        ActorRef x$6 = qual$2.$bang$default$2((Object)x$5);
        qual$2.$bang((Object)x$5, x$6);
    }

    public EventListener(ActorRef scheduler, ActorRef controlTaskExecutor, RepositoryService repositoryService) {
        this.scheduler = scheduler;
        this.controlTaskExecutor = controlTaskExecutor;
        this.repositoryService = repositoryService;
        Logging.class.$init$((Logging)this);
        this.actorSystem = SchedulerActorSystem$.MODULE$.actorSystem();
        this.executionContext = this.actorSystem().dispatcher();
    }

    public EventListener() {
        this(SchedulerActorSystem$.MODULE$.scheduler(), SchedulerActorSystem$.MODULE$.controlTaskExecutor(), ServiceHolder.getRepositoryService());
    }
}

