package com.xebialabs.xlplatform.repository.sql.db

import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema.METADATA
import slick.jdbc.JdbcProfile

object MetadataSchema {

  abstract class Table(val TABLE: String)

  object METADATA extends Table("XL_METADATA") {
    val name: String = "NAME"

    val entry: String = "ENTRY"
  }

}

object Tables {

  lazy val profile: JdbcProfile = Database.databaseType.profile

  import profile.api._

  case class Metadata(name: String, entry: String)

  class MetadataTable(tag: Tag) extends Table[Metadata](tag, METADATA.TABLE) {

    def name = column[String](METADATA.name, O.PrimaryKey)

    def entry = column[String](METADATA.entry)

    def * = (name, entry).<>(Metadata.tupled, Metadata.unapply)
  }

  val metadata = TableQuery[MetadataTable]
}
