package com.xebialabs.xlplatform.repository.sql

import com.xebialabs.deployit.repository.RepositoryMetadataService
import com.xebialabs.license.LicenseRepositoryIdException
import com.xebialabs.xlplatform.repository.sql.db.Tables
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import slick.jdbc.JdbcProfile

object MetadataKeys {
  val repositoryColumnName = "repository_id"
}

class SqlRepositoryMetadataService @Autowired()(database: Database) extends RepositoryMetadataService with Logging {

  import database._

  val profile: JdbcProfile = config.databaseType.profile

  import profile.api._

  // Lazy initialised to prevent frequent querying
  protected var storedRepoId: Option[String] = None

  override def validateAndStoreRepositoryId(repositoryId: String): Unit = {
    (Option(repositoryId), getRepositoryId) match {
      case (Some(newRepoId), Some(current)) => if (current != newRepoId) throw new LicenseRepositoryIdException(repositoryId)
      case (Some(_), None) => saveRepositoryId(repositoryId)
      case _ => // Don't store
    }
  }

  def getRepositoryId: Option[String] = {
    storedRepoId match {
      case Some(_) =>
      case None => storedRepoId = queryRepositoryId()
    }
    storedRepoId
  }

  def queryRepositoryId(): Option[String] = runAwait(Tables.metadata
    .filter(_.name === MetadataKeys.repositoryColumnName)
    .map(_.entry).result).headOption

  def saveRepositoryId(id: String): Unit =
    runAwait(Tables.metadata.insertOrUpdate(Tables.Metadata(MetadataKeys.repositoryColumnName, id)))

}
