package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static com.xebialabs.deployit.util.Tuple.of;

public class ChangeSet {
    private SCMTraceabilityData scmTraceabilityData;
    private List<ConfigurationItem> createCis = new ArrayList<>();
    private List<ConfigurationItem> updateCis = new ArrayList<>();
    private List<Tuple<Integer, String>> deleteCiIds = new ArrayList<>();
    private List<ConfigurationItem> createOrUpdateCis = new ArrayList<>();
    private List<Tuple<String, String>> renameCis = new ArrayList<>();
    private List<Tuple<String, String>> moveCis = new ArrayList<>();
    private List<Tuple<String, String>> copyCis = new ArrayList<>();
    private boolean disableVersionHistory = false;
    private List<ConfigurationItem> createOrUpdateActualUpdatedCis = new ArrayList<>();
    private List<ConfigurationItem> createOrUpdateActualCreatedCis = new ArrayList<>();

    public void create(ConfigurationItem ci) {
        this.createCis.add(ci);
    }

    public void create(List<? extends ConfigurationItem> entities) {
        this.createCis.addAll(entities);
    }

    public void update(ConfigurationItem ci) {
        this.updateCis.add(ci);
    }

    public void update(List<? extends ConfigurationItem> entities) {
        this.updateCis.addAll(entities);
    }

    public void createOrUpdate(ConfigurationItem entity) {
        this.createOrUpdateCis.add(entity);
    }

    public void createOrUpdate(List<? extends ConfigurationItem> entities) {
        this.createOrUpdateCis.addAll(entities);
    }

    public void delete(ConfigurationItem ci) {
        this.deleteCiIds.add(new Tuple<>(ci.get$internalId(), ci.getId()));
    }

    public void delete(List<Tuple<Integer, String>> ids) {
        this.deleteCiIds.addAll(ids);
    }

    public void delete(Collection<? extends ConfigurationItem> cis) {
        delete(cis.stream().map(ci -> new Tuple<>(ci.get$internalId(), ci.getId())).collect(Collectors.toList()));
    }

    public void deleteByIds(List<String> ids) {
        delete(ids.stream().map(id -> new Tuple<Integer, String>(null, id)).collect(Collectors.toList()));
    }

    public void deleteById(String id) {
        this.deleteCiIds.add(new Tuple<>(null, id));
    }

    public void rename(String id, String newName) {
        this.renameCis.add(of(id, newName));
    }

    public void rename(ConfigurationItem ci, String newName) {
        this.renameCis.add(of(ci.getId(), newName));
    }

    public void move(String ci, String newId) {
        this.moveCis.add(of(ci, newId));
    }

    public void copy(String ci, String newId) {
        this.copyCis.add(of(ci, newId));
    }

    public void setDisableVersionHistory(boolean checkPointRequested) {
        this.disableVersionHistory = checkPointRequested;
    }

    public SCMTraceabilityData getSCMTraceabilityData() {
        return scmTraceabilityData;
    }

    public void setSCMTraceabilityData(SCMTraceabilityData scmTraceabilityData) {
        this.scmTraceabilityData = scmTraceabilityData;
    }

    public List<ConfigurationItem> getCreateCis() {
        return createCis;
    }

    public List<ConfigurationItem> getUpdateCis() {
        return updateCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateCis() {
        return createOrUpdateCis;
    }

    public List<String> getDeleteCiIds() {
        return deleteCiIds.stream().map(Tuple::getB).collect(Collectors.toList());
    }

    public List<Tuple<Integer, String>> getDeleteCiIdsWithInternalIds() {
        return deleteCiIds;
    }

    public List<Tuple<String, String>> getRenameCis() {
        return renameCis;
    }

    public List<Tuple<String, String>> getMoveCis() {
        return moveCis;
    }

    public List<Tuple<String, String>> getCopyCis() {
        return copyCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualUpdatedCis() {
        return createOrUpdateActualUpdatedCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualCreatedCis() {
        return createOrUpdateActualCreatedCis;
    }

    public boolean isDisableVersionHistory() {
        return disableVersionHistory;
    }

}
