package com.xebialabs.deployit.service.externalproperties.validation

import java.util

import com.xebialabs.deployit.plugin.api.udm.ExternalProperty
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage

import scala.collection.JavaConverters._

class ExternalPropertiesValidatorChain(private val externalPropertiesValidators: List[ExternalPropertiesValidator]) {

  def validate(bci: BaseConfigurationItem): util.List[ValidationMessage] = {
    var validationMessages: List[ValidationMessage] = List()
    externalPropertiesValidators.foreach(epv => validationMessages ++= epv.validate(bci))
    validationMessages.asJava
  }

}
