package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.service.externalproperties.ExternalPropertiesResolver;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.File;

@Component
public class RepositoryAdapterFactory implements RepositoryFactory {

    private final RepositoryService repositoryService;
    private final Validator validator;
    private final ExternalPropertiesResolver resolver;

    @Autowired
    public RepositoryAdapterFactory(RepositoryService repositoryService, Validator validator, @Qualifier("externalPropertiesResolverImpl")  ExternalPropertiesResolver resolver) {
        this.repositoryService = repositoryService;
        this.validator = validator;
        this.resolver = resolver;
    }

    @Override
    public Repository create() {
        return create((WorkDir) null);
    }

    @Override
    public Repository create(File temporaryWorkDir) {
        return create(new WorkDir((LocalFile) LocalFile.valueOf(temporaryWorkDir)));
    }

    public Repository create(WorkDir workDir) {
        return new RepositoryAdapter(repositoryService, validator, resolver, workDir);
    }
}
