package com.xebialabs.deployit.repository

import com.xebialabs.deployit.engine.spi.command.{CreateCiCommand, CreateCisCommand, RepositoryBaseCommand, UpdateCiCommand, UpdateCisCommand}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact
import com.xebialabs.platform.script.jython.JythonSupport


object OnSave {

  private val THIS_CI_KEY: String = "thisCi"

  def executeOnSaveScript(command: RepositoryBaseCommand): Unit =
    command match {
      case create: CreateCiCommand => executeOnSaveScript(create.getCi)
      case create: CreateCisCommand => create.getCis.forEach(executeOnSaveScript(_))
      case update: UpdateCiCommand if update.getUpdate.getPreviousCi == null =>
        executeOnSaveScript(update.getUpdate.getNewCi)
      case update: UpdateCisCommand =>
        update.getUpdates.stream().filter(_.getPreviousCi == null).forEach(u => executeOnSaveScript(u.getNewCi))
      case _ =>

    }

  def executeOnSaveScript(ci: ConfigurationItem): Unit =
    ci match {
      case artifact: BaseDeployableArtifact =>
        if (artifact.getOnSaveScriptPath == null || artifact.getOnSaveScriptPath.isEmpty) return
        new JythonSupport {}.executeScriptWithVariables(artifact.getOnSaveScriptPath, Map(THIS_CI_KEY -> artifact))
      case _ =>
    }

}