package com.xebialabs.deployit.repository;

import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseQueryTemplate implements QueryTemplate {
    protected final String queryString;
    protected final Map<String, Object> parameters = new LinkedHashMap<>();
    protected long page = 0;
    protected long resultsPerPage = 0;
    protected int depth = Integer.MAX_VALUE;

    public BaseQueryTemplate(String query) {
        this.queryString = query;
    }

    public BaseQueryTemplate(String query, Map<String, Object> parameters) {
        this.queryString = query;
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }

    public QueryTemplate setParameter(String key, Object value) {
        parameters.put(key, value);
        return this;
    }

    public QueryTemplate setPage(long page) {
        this.page = page;
        return this;
    }

    public QueryTemplate setResultsPerPage(long resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
        return this;
    }

    public QueryTemplate setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    public int getDepth() {
        return depth;
    }
}
