package com.xebialabs.deployit.repository;

public interface QueryTemplate {
    /**
     * Sets the value of a parameter.
     *
     * @param key the parameter as mentioned in the query string.
     * @param value the value of the parameter.
     * @return this
     */
    QueryTemplate setParameter(String key, Object value);

    /**
     * The page number to request
     * @param page
     * @return
     */
    QueryTemplate setPage(long page);

    /**
     * The paging size
     * @param resultsPerPage
     * @return
     */
    QueryTemplate setResultsPerPage(long resultsPerPage);

    /**
     * The tree-depth to read
     * @param depth
     * @return
     */
    QueryTemplate setDepth(int depth);

    int getDepth();
}
