package com.xebialabs.plugin.protocol

import java.net.URL

import de.schlichtherle.truezip.util.UriEncoder
import de.schlichtherle.truezip.util.UriEncoder.Encoding

package object xlp {

  object Extension {
    def unapply(path: String): Option[String] = {
      path.lastIndexWhere( _ == '.') match {
        case idx if idx != -1 => Some(path.drop(idx + 1))
        case _ => None
      }
    }
  }

  implicit class XlpUrlUtils(url: URL) {
    val path = url.getPath
    private val extensions = {
      path.split("!/").init.collect {
        case Extension(ext) => ext
      }
    }
    val multiProtocol = ("file" +: extensions).reverse.mkString(":")
  }

  private[protocol] implicit class PathUtils(val path: String) extends AnyVal {
    def encoded: String = new UriEncoder().encode(path, Encoding.PATH)

    def dropFirstSlash: String = path.dropWhile(_ == '/')
  }
}
