package com.xebialabs.plugin

import java.io.File

import com.xebialabs.plugin.classloader.PluginClassLoader
import com.xebialabs.xlplatform.utils.PerformanceLogging
import de.schlichtherle.truezip.file.{TArchiveDetector, TConfig}
import de.schlichtherle.truezip.fs.archive.zip.JarDriver
import de.schlichtherle.truezip.fs.spi.FsDriverService
import de.schlichtherle.truezip.socket.sl.IOPoolLocator
import de.schlichtherle.truezip.util.ServiceLocator

import scala.collection.convert.ImplicitConversions._

object Xlp extends PerformanceLogging {

  initXlpProtocol()

  def init(pluginExtension: String, xlpDirectory: File): Unit = {
    init(pluginExtension, Seq(xlpDirectory), Seq[File]())
  }

  def init(pluginExtension: String, xlpDirectories: java.lang.Iterable[File], explodedDirectories: java.lang.Iterable[File]): Unit = logWithTime("Initializing of xlp") {
    logger.info(s"Initializing xl plugins with extension .$pluginExtension in folders ${xlpDirectories.map(_.getAbsolutePath).mkString(",")}")
    initTrueZipDriver(pluginExtension)
    val xlpClassLoader = createXlpClassLoader(pluginExtension, xlpDirectories, explodedDirectories)
    Thread.currentThread().setContextClassLoader(xlpClassLoader)
    registerTrueZipFsDriversInPlugins(xlpClassLoader)
  }

  private[this] def registerTrueZipFsDriversInPlugins(loader: ClassLoader): Unit = {
    val config = TConfig.get
    val registeredDrivers = config.getArchiveDetector.get
    val locatedDrivers = new ServiceLocator(loader).getServices(classOf[FsDriverService]).flatMap(_.get)
    val unregisteredDrivers = locatedDrivers.filterNot(x => registeredDrivers.containsKey(x._1)).map(x => Array(x._1, x._2)).toArray
    if (!unregisteredDrivers.isEmpty)
      config.setArchiveDetector(new TArchiveDetector(config.getArchiveDetector, unregisteredDrivers))
  }

  private[plugin] def initTrueZipDriver(pluginExtension: String): Unit = {
    TConfig.get().setArchiveDetector(new TArchiveDetector(TArchiveDetector.ALL, pluginExtension, new JarDriver(IOPoolLocator.SINGLETON)))
  }

  private[plugin] def initXlpProtocol(): Unit = System.setProperty("java.protocol.handler.pkgs", "com.xebialabs.plugin.protocol")

  private[plugin] def createXlpClassLoader(pluginExtension: String, xlpDirectories: Iterable[File], explodedDirectories: Iterable[File]) =
    new PluginClassLoader(pluginExtension, xlpDirectories, explodedDirectories, getClass.getClassLoader)
}
