package com.xebialabs.plugin.protocol.xlp

import java.net.{URI, URL}

import de.schlichtherle.truezip.file.TFile
import grizzled.slf4j.Logging

object XlpURL {
  def apply(filePath: String, libraryName: String, entry: String): URL =
    new URL("xlp", null, s"/${filePath.dropFirstSlash.encoded}!/${libraryName.dropFirstSlash.encoded}!/${entry.dropFirstSlash.encoded}")

  def apply(filePath: String, libraryName: String): URL = new URL("xlp", null, s"/${filePath.dropFirstSlash.encoded}!/${libraryName.encoded}")
}

object JarURL {
  def apply(libraryPath: String, entry: String): URL = new URL("jar", null, s"file:/${libraryPath.dropFirstSlash.encoded}!/${entry.encoded}")
}
