package com.xebialabs.plugin.zip

import java.io.{FilenameFilter, File}

trait PluginScanner {

  protected def findAllPluginFiles(pluginFolder: File, pluginExtension : String): Array[File] = pluginFolder.listFiles(new FilenameFilter {
    val ext = s".$pluginExtension"
    override def accept(dir: File, name: String): Boolean = name.endsWith(ext)
  })

}