package com.xebialabs.plugin.protocol

import java.net.URL

import de.schlichtherle.truezip.util.UriEncoder
import de.schlichtherle.truezip.util.UriEncoder.Encoding

import scalax.file.Path

package object xlp {

  object Extension {
    def unapply(path: String) = Path.fromString(path).extension
  }

  implicit class XlpUrlUtils(url: URL) {
    val path = url.getPath
    private val extensions = {
      path.split("!/").init.collect {
        case Extension(ext) => ext
      }
    }
    val multiProtocol = ("file" +: extensions).reverse.mkString(":")
  }

  private[protocol] val encoder = new UriEncoder()

  private[protocol] implicit class PathUtils(val path: String) extends AnyVal {
    def encoded: String = encoder.encode(path, Encoding.PATH)

    def dropFirstSlash: String = path.dropWhile(_ == '/')
  }
}
