package com.xebialabs.plugin.protocol.xlp

import java.net.{URI, URL}

import de.schlichtherle.truezip.file.TFile

object XlpURL {
  def apply(filePath: String, libraryName: String, entry: String): URL =
    new URL("xlp", "", s"/${filePath.dropFirstSlash.encoded}!/${libraryName.encoded}!/${entry.encoded}")

  def apply(filePath: String, libraryName: String): URL = new URL("xlp", "", s"/${filePath.dropFirstSlash.encoded}!/${libraryName.encoded}")
}

object XlpURI {
  def apply(url: URL) = new URI(s"${url.multiProtocol}://${url.path}")
}

object JarURL {
  def apply(libraryPath: String, entry: String): URL = new URL("jar", null, s"file:/${libraryPath.dropFirstSlash.encoded}!/${entry.encoded}")
}

object EntryUrlE {
  def unapply(tFile: TFile) = {
    if(tFile.getName != null && tFile.getEnclArchive == null)
      Option(tFile.toURI.toURL)
    else None
  }
}

object XlpEntryUrlE {
  def unapply(tFile: TFile) = {
    if(tFile.getTopLevelArchive != null && tFile.getEnclArchive != null && tFile.getEnclArchive.getEnclEntryName != null)
      Option(XlpURL(tFile.getTopLevelArchive.getAbsolutePath, tFile.getEnclArchive.getEnclEntryName, tFile.getEnclEntryName))
    else None
  }
}

object XlpLibraryUrlE {
  def unapply(tFile: TFile) = {
    if(tFile.getTopLevelArchive != null && !tFile.getTopLevelArchive.getName.endsWith("jar"))
      Option(XlpURL(tFile.getTopLevelArchive.getAbsolutePath, tFile.getEnclEntryName))
    else None
  }
}

object JarEntryUrlE {
  def unapply(tFile: TFile) = {
    if(tFile.getTopLevelArchive != null && tFile.getTopLevelArchive.getName.endsWith("jar") && tFile.getEnclEntryName != null)
      Option(JarURL(tFile.getTopLevelArchive.getAbsolutePath, tFile.getEnclEntryName))
    else None
  }
}

object PluginURL {
  def apply(tFile: TFile): URL = tFile match {
    case EntryUrlE(url) => url
    case XlpEntryUrlE(url) => url
    case XlpLibraryUrlE(url) => url
    case JarEntryUrlE(url) => url
  }
}