package com.xebialabs.plugin.classloader;

import com.xebialabs.plugin.protocol.xlp.PluginURL;
import de.schlichtherle.truezip.file.TFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.MalformedURLException;
import java.net.URL;

class ResourceFinder {

    private static final Logger logger = LoggerFactory.getLogger(ResourceFinder.class);

    public static URL findResourceInDirs(String path , Iterable<TFile> dirs) throws MalformedURLException {
        String[] pathElements = path.split("/");
        for (TFile dir : dirs) {
            logger.trace("Scanning {} for {}", dir, pathElements);
            if (dir.isDirectory()) {
                URL potentiallyNull = findResourceInDir(pathElements, dir, 0);
                if (potentiallyNull != null) {
                    return potentiallyNull;
                }
            }
        }

        return null;
    }

    private static URL findResourceInDir(String[] pathElements, TFile dir, int pathIndex) throws MalformedURLException {
        for (TFile tFile : dir.listFiles()) {
            logger.trace("Scanning {} for {} with index {}", tFile, pathElements, pathIndex);
            if (tFile.isArchive()) {
                URL resourceInDir = findResourceInDir(pathElements, tFile, 0);
                if (resourceInDir != null) {
                    return resourceInDir;
                }
            } else if (tFile.isDirectory()) {
                if (pathElements[pathIndex].equals(tFile.getName())) {
                    if (pathElements.length == pathIndex + 1) {
                        return PluginURL.apply(tFile);
                    }
                    URL resourceInDir = findResourceInDir(pathElements, tFile, pathIndex + 1);
                    if (resourceInDir != null) {
                        return resourceInDir;
                    }
                }
            } else if (pathElements[pathIndex].equals(tFile.getName()) && pathElements.length == pathIndex + 1) {
                return PluginURL.apply(tFile);
            }
        }
        return null;
    }
}
