package com.xebialabs.plugin

import java.io.File

import com.xebialabs.plugin.classloader.PluginClassLoader
import com.xebialabs.xlplatform.utils.PerformanceLogging
import de.schlichtherle.truezip.file.{TArchiveDetector, TConfig}
import de.schlichtherle.truezip.fs.archive.zip.JarDriver
import de.schlichtherle.truezip.socket.sl.IOPoolLocator
import scala.collection.JavaConverters._

object Xlp extends PerformanceLogging {

  initXlpProtocol()

  def init(pluginExtension: String, xlpDirectory: File): Unit = {
    init(pluginExtension, Seq(xlpDirectory).asJava, Seq[File]().asJava)
  }

  def init(pluginExtension: String, xlpDirectories: java.lang.Iterable[File], explodedDirectories: java.lang.Iterable[File]): Unit = logWithTime("Initializing of xlp") {
    logger.info(s"Initializing xl plugins with extension .$pluginExtension in folders ${xlpDirectories.asScala.map(_.getAbsolutePath).mkString(",")}")
    initTrueZipDriver(pluginExtension)
    Thread.currentThread().setContextClassLoader(createXlpClassLoader(pluginExtension, xlpDirectories.asScala, explodedDirectories.asScala))
  }

  private[plugin] def initTrueZipDriver(pluginExtension: String): Unit = {
    TConfig.get().setArchiveDetector(new TArchiveDetector(TArchiveDetector.ALL, pluginExtension, new JarDriver(IOPoolLocator.SINGLETON)))
  }

  private[plugin] def initXlpProtocol(): Unit = System.setProperty("java.protocol.handler.pkgs", "com.xebialabs.plugin.protocol")

  private[plugin] def createXlpClassLoader(pluginExtension: String, xlpDirectories: Iterable[File], explodedDirectories: Iterable[File]) =
    new PluginClassLoader(pluginExtension, xlpDirectories, explodedDirectories, getClass.getClassLoader)
}
