package com.xebialabs.plugin.protocol.xlp

import java.io.InputStream
import java.net.{URL, URLConnection, URLStreamHandler}

import de.schlichtherle.truezip.file.{TFile, TFileInputStream}
import grizzled.slf4j.Logging

class Handler extends URLStreamHandler {
  override def openConnection(u: URL): URLConnection = {
    new XlpURLConnection(u)
  }

  override def toExternalForm(u: URL): String = super.toExternalForm(u).replaceFirst("xlp:", s"${u.multiProtocol}:")
}


class XlpURLConnection(url: URL) extends URLConnection(url) with Logging {
  override def connect() = {
    logger.error(s"Called open for $url")
    ???
  }
  override def getInputStream: InputStream = {
    new TFileInputStream(new TFile(url.toURI).getPath)
  }
}
