/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.util;

import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.plugin.classloader.PluginClassLoader;
import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.exception.InvalidPluginVersionPropertiesException;
import com.xebialabs.plugin.manager.exception.MissingPluginVersionPropertiesException;
import com.xebialabs.plugin.manager.metadata.PluginVersionProperties;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.protocol.xlp.JarURL$;
import de.schlichtherle.truezip.file.TFile;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Marker;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.FileSystemUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.util.Using;
import scala.util.Using$;

public final class PluginFileUtils$
implements Logging {
    public static final PluginFileUtils$ MODULE$ = new PluginFileUtils$();
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginFileUtils$ pluginFileUtils$ = this;
        synchronized (pluginFileUtils$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public String getPluginExtension(String filename) {
        Option<String> option = ConfigWrapper$.MODULE$.getValidExtension(filename);
        if (option instanceof Some) {
            Some some = (Some)option;
            String extension = (String)some.value();
            return extension;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Filename must end with '" + ((IterableOnceOps)ConfigWrapper$.MODULE$.getExtensions().map((Function1 & Serializable)ext -> "." + ext)).mkString(" or ") + "'");
        }
        throw new MatchError(option);
    }

    public PluginVersionProperties getPluginPropertiesForZip(Path filePath) {
        return this.getPluginPropertiesForZip(filePath.toFile());
    }

    public PluginVersionProperties getPluginPropertiesForZip(String filename, byte[] bytes) {
        return (PluginVersionProperties)this.withTmpDir((Function1 & Serializable)tmpDir -> {
            File file = MODULE$.getTemporaryPluginFile((Path)tmpDir, filename, bytes);
            return MODULE$.getPluginPropertiesForZip(file);
        });
    }

    public PluginVersionProperties getPluginPropertiesForZip(File file) {
        PluginVersionProperties pluginVersionProperties;
        try {
            String filename = file.getName();
            pluginVersionProperties = (PluginVersionProperties)Using$.MODULE$.resource((Object)new ZipFile(file), (Function1 & Serializable)zipfile -> {
                Option option = Option$.MODULE$.apply((Object)zipfile.getEntry("plugin-version.properties"));
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new MissingPluginVersionPropertiesException("Could not read plugin-version.properties in " + filename);
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                ZipEntry entry = (ZipEntry)some.value();
                .colon.colon urls = new .colon.colon((Object)JarURL$.MODULE$.apply(file.getAbsolutePath(), entry.getName()), (List)Nil$.MODULE$);
                Properties props = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource((Seq)urls){

                    public void customizeConnection(URLConnection con) {
                        super.customizeConnection(con);
                        if (con instanceof JarURLConnection) {
                            con.setUseCaches(false);
                            return;
                        }
                    }
                });
                Option name = Option$.MODULE$.apply((Object)props.getProperty("plugin"));
                Option version = Option$.MODULE$.apply((Object)props.getProperty("version"));
                Option pluginType = Option$.MODULE$.apply((Object)props.getProperty("type"));
                if (name.isDefined() && version.isDefined()) {
                    return new PluginVersionProperties((String)name.get(), (String)version.get(), (Option<String>)pluginType);
                }
                throw new InvalidPluginVersionPropertiesException(filename + " does not have a valid plugin-version.properties");
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ZipException e) {
            throw new IllegalStateException(e);
        }
        return pluginVersionProperties;
    }

    private <R> R withTmpDir(Function1<Path, R> block) {
        Object object;
        Path tmpDir = Files.createTempDirectory("plugin", new FileAttribute[0]);
        try {
            object = block.apply((Object)tmpDir);
        }
        finally {
            FileSystemUtils.deleteRecursively((Path)tmpDir);
        }
        return (R)object;
    }

    private File getTemporaryPluginFile(Path tmpDir, String filename, byte[] bytes) {
        Path pluginPath = tmpDir.resolve(filename);
        return Files.write(pluginPath, bytes, new OpenOption[0]).toFile();
    }

    public <T> void deletePluginsFromFilesystem(Seq<T> plugins, Function1<T, Path> getPluginFile, Function1<T, String> getPluginName, Function1<T, Option<String>> getPluginVersion) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 instanceof PluginClassLoader) {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)classLoader2;
            try {
                BoxedUnit boxedUnit;
                try {
                    pluginClassLoader.clearClasspathRoots();
                    plugins.foreach((Function1 & Serializable)plugin -> {
                        PluginFileUtils$.$anonfun$deletePluginsFromFilesystem$2(this, getPluginFile, getPluginName, getPluginVersion, plugin);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Error while deleting plugins", (Function0 & Serializable)() -> e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                pluginClassLoader.refreshDirs();
            }
            return;
        }
        plugins.foreach((Function1 & Serializable)plugin -> {
            PluginFileUtils$.$anonfun$deletePluginsFromFilesystem$8(this, getPluginFile, getPluginName, getPluginVersion, plugin);
            return BoxedUnit.UNIT;
        });
    }

    public <T> Function1<T, None$> deletePluginsFromFilesystem$default$4() {
        return (Function1 & Serializable)x$1 -> None$.MODULE$;
    }

    public Path getPluginFileAndName(DbPlugin plugin, Path pluginsDir) {
        String fileName = plugin.name() + plugin.version().map((Function1 & Serializable)v -> "-" + v).getOrElse((Function0 & Serializable)() -> "") + "." + plugin.extension();
        return pluginsDir.resolve(plugin.source().toString()).resolve(fileName);
    }

    private final void deleteFile$1(Path pluginFile) {
        if (Files.exists(pluginFile, new LinkOption[0])) {
            TFiles.umountQuietly((TFile)new TFile(pluginFile.toFile()));
            FileUtils.forceDelete((File)pluginFile.toFile());
            return;
        }
        this.logger().warn((Function0 & Serializable)() -> "Plugin file " + pluginFile + " does not exist, cannot delete.");
    }

    public static final /* synthetic */ void $anonfun$deletePluginsFromFilesystem$2(PluginFileUtils$ $this, Function1 getPluginFile$1, Function1 getPluginName$1, Function1 getPluginVersion$1, Object plugin) {
        Path pluginFile = (Path)getPluginFile$1.apply(plugin);
        String name = (String)getPluginName$1.apply(plugin);
        String versionStr = (String)((Option)getPluginVersion$1.apply(plugin)).map((Function1 & Serializable)v -> " version " + v).getOrElse((Function0 & Serializable)() -> "");
        MODULE$.logger().info((Function0 & Serializable)() -> "Removing plugin " + name + versionStr + " from filesystem");
        $this.deleteFile$1(pluginFile);
    }

    public static final /* synthetic */ void $anonfun$deletePluginsFromFilesystem$8(PluginFileUtils$ $this, Function1 getPluginFile$1, Function1 getPluginName$1, Function1 getPluginVersion$1, Object plugin) {
        Path pluginFile = (Path)getPluginFile$1.apply(plugin);
        String name = (String)getPluginName$1.apply(plugin);
        String versionStr = (String)((Option)getPluginVersion$1.apply(plugin)).map((Function1 & Serializable)v -> " version " + v).getOrElse((Function0 & Serializable)() -> "");
        MODULE$.logger().info((Function0 & Serializable)() -> "Removing plugin " + name + versionStr + " (No classloader) from filesystem");
        $this.deleteFile$1(pluginFile);
    }

    private PluginFileUtils$() {
    }
}

