package com.xebialabs.plugin.manager.service

// Change message to Seq[String]?
class InstallationResult(val success: Boolean, val message: String, val warnings: Seq[String] = Seq.empty, val errors: Seq[String] = Seq.empty)

case class InstallationFailure(pluginName: String, reason: String, override val warnings: Seq[String] = Seq.empty, override val errors: Seq[String] = Seq.empty)
  extends InstallationResult(false, s"Installation of $pluginName failed. $reason", warnings, errors)

case class InstallationSuccess(pluginName: String, requiresRestart: Boolean = true, override val warnings: Seq[String] = Seq.empty)
  extends InstallationResult(success = true, message = s"Installation of $pluginName succeeded", warnings, Seq.empty)

case class SameVersionInstalledAlready(pluginName: String)
  extends InstallationResult(success = false, message = s"Installation of $pluginName aborted. The same plugin version already exists in the system.")

case class DifferentVersionInstalledAlready(pluginName: String)
  extends InstallationResult(success = false, message = s"Could not install $pluginName because another version of this plugin is already installed")

case class RepositoryNotFound(repositoryName: String, pluginName: String)
  extends InstallationResult(success = false, message = s"Installation of $pluginName aborted. Unknown plugin repository: $repositoryName.")

case class PluginNotFound(pluginName: String)
  extends InstallationResult(success = false, message = s"Installation of $pluginName aborted. Unknown plugin in repository.")

case class UpdateSuccess(pluginName: String, requiresRestart: Boolean = true)
  extends InstallationResult(success = true, message = s"Update of plugin $pluginName succeeded")

case class UpdateFailed(pluginName: String, reason: String)
  extends InstallationResult(success = false, message = s"Update of $pluginName failed. $reason")

case class ZeroInstalledPluginsFoundForUpdate(pluginName: String)
  extends InstallationResult(success = false, message = s"Unable to find a plugin to update that would match your input criteria: ($pluginName)")

case class MultipleInstalledPluginsFoundForUpdate(pluginName: String)
  extends InstallationResult(success = false, message = s"Multiple installed plugins found for update for your input criteria: ($pluginName). Please narrow down the criteria.")

case class MultipleAvailablePluginsFoundForUpdate(pluginName: String, repoName: String)
  extends InstallationResult(success = false, message = s"Multiple available plugins found for update in remote repository $repoName for your input criteria: ($pluginName). Please narrow down the criteria.")

case class ZeroAvailablePluginsFoundForUpdate(pluginName: String, repoName: String)
  extends InstallationResult(success = false, message = s"Unable to find a plugin in remote repository $repoName to update the installed plugin with. Please update your input criteria ($pluginName)")

case class PluginAlreadyAtLatestVersion(pluginName: String)
  extends InstallationResult(success = true, message = s"Installed plugin already at highest version. Update will not be performed.")
