package com.xebialabs.plugin.manager.event

import com.xebialabs.deployit.engine.spi.event.{SpringInstantiatedListener, SystemStartedEvent}
import com.xebialabs.plugin.manager.service.PluginService
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe
import org.springframework.stereotype.Component

@Component
class UpdateRepositoryEventListener(val pluginService: PluginService) extends SpringInstantiatedListener with Logging  {

  @Subscribe def updateRepositories(event: SystemStartedEvent): Unit = {
    try {
      pluginService.update()
    } catch {
      case e: Exception => logger.error("Error while loading the plugins", e)
    }
  }

}
