package com.xebialabs.plugin.manager.repository.nexus

import com.xebialabs.plugin.manager.repository.protocol.{ArtifactMetadata, ArtifactResult}

import java.io.InputStream
import java.nio.file.Path


// For Uploading
case class NexusArtifact(content: Either[Path, Either[InputStream, String]], metadata: ArtifactMetadata, classifier: Option[String] = None)

object NexusArtifact {
  def apply(path: Path, metadata: ArtifactMetadata, classifier: Option[String]): NexusArtifact =
    new NexusArtifact(Left(path), metadata, classifier)

  def apply(content: String, metadata: ArtifactMetadata, classifier: Option[String]): NexusArtifact =
    new NexusArtifact(Right(Right(content)), metadata, classifier)

  def apply(input: InputStream, metadata: ArtifactMetadata, classifier: Option[String]): NexusArtifact =
    new NexusArtifact(Right(Left(input)), metadata, classifier)
}

case class RepoDetails(repositoryId: String,
                       repositoryName: String,
                       repositoryContentClass: String,
                       repositoryKind: String,
                       repositoryPolicy: String,
                       repositoryURL: String)

case class NexusArtifactResults(totalCount: Int,
                                from: Int,
                                count: Int,
                                tooManyResults: Boolean,
                                collapsed: Boolean,
                                repoDetails: Seq[RepoDetails],
                                data: Seq[ArtifactResult])
