package com.xebialabs.plugin.manager.repository.storage

import com.xebialabs.plugin.manager.PluginId
import com.xebialabs.plugin.manager.metadata.{ArtifactId, ExtendedMetadata, PluginMetadata}

import java.io.{File, InputStream}


trait PluginMetadataStorage {
  def repositoryName: String

  def clear(): Unit

  def store(data: Seq[PluginId.Artifact], pluginsMetadata: Map[ArtifactId, ExtendedMetadata]): Unit

  def get(id: ArtifactId): Option[PluginMetadata]

  def get(id: PluginId.Artifact): Option[PluginMetadata] = get(id.toArtifactId)

  def storeLogos(artifactIds: Seq[String])(data: InputStream): Seq[String]

  def getLogo(groupId: String, artifactId: String): Option[File]

  def search(name: Option[String]): Map[ArtifactId, Option[PluginMetadata]]

  def list(): Map[ArtifactId, Option[PluginMetadata]] = search(None)
}

sealed abstract class PluginMetadataStorageException(msg: String, e: Throwable = null) extends Exception(msg, e)

object PluginMetadataStorageException {
  case class UnknownPlugin(repository: String, id: PluginId) extends PluginMetadataStorageException(
    s"Unknown plugin in repository '$repository': '${id.id}'"
  )
}



