package com.xebialabs.plugin.manager.validator

import com.xebialabs.plugin.manager.Plugin

/**
 * Validates type system that would be created after certain plugin installation.
 *
 * It must not modify existing type system.
 */
trait TypeSystemValidator {

  /**
   * Validates the state of the future type system that would be created if plugin would be installed.
   *
   * @param plugin plugin that is about to be installed and for which type system needs to be checked
   * @return result of validation of the new type system state
   */
  def validate(plugin: Plugin): TypeSystemValidationResults
}
