package com.xebialabs.plugin.manager.repository.artifactory

import com.xebialabs.plugin.manager.metadata.Version
import com.xebialabs.plugin.manager.repository.protocol.ArtifactMetadata
import org.apache.pekko.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


trait ArtifactoryJsonProtocol extends SprayJsonSupport with DefaultJsonProtocol
  with Version.Protocol {

  implicit val artifactMetadataFormat: RootJsonFormat[ArtifactMetadata] =
    jsonFormat(ArtifactMetadata.apply(_: String, _: String, _: String, _: String), "groupId", "artifactId", "version", "packaging")

  implicit val artifactoryArtifactResultFormat: RootJsonFormat[ArtifactoryArtifactResult] =
    jsonFormat(ArtifactoryArtifactResult.apply, "downloadUri", "ext", "version", "classifier")

  implicit val artifactoryArtifactResultsFormat: RootJsonFormat[ArtifactoryArtifactResults] =
    jsonFormat(ArtifactoryArtifactResults, "results")
}
